/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.seppiko.commons.utils.Environment;
import org.seppiko.commons.utils.ObjectUtil;

public class StreamUtil {
    public static InputStream findFileInputStream(Class<?> clazz, String pathname) {
        try {
            return new FileInputStream(StreamUtil.findFile(clazz, pathname));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File findFile(Class<?> clazz, String pathname) {
        String _pathname = StreamUtil.getClassLoaderPath(clazz.getClassLoader(), pathname);
        _pathname = _pathname == null ? pathname : _pathname;
        return new File(_pathname);
    }

    private static String getClassLoaderPath(ClassLoader cl, String path) {
        URL url = cl.getResource(path);
        return ObjectUtil.isNull(url) ? null : url.getPath();
    }

    public static File loadFile(String path) throws IllegalArgumentException, IOException {
        String targetPath;
        File folder;
        File file = new File(path);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Target path is not a valid file.");
        }
        if (file.exists()) {
            return file;
        }
        String absolutePath = file.getAbsolutePath();
        int lastFolder = absolutePath.lastIndexOf(47);
        if (lastFolder < 0) {
            lastFolder = absolutePath.lastIndexOf(92);
        }
        if (!(folder = new File(targetPath = absolutePath.substring(0, lastFolder))).mkdirs()) {
            throw new IOException("Failed to create destination folder.");
        }
        if (!file.createNewFile()) {
            throw new IllegalArgumentException("Unable to load target file.");
        }
        return file;
    }

    public static InputStream getStream(Class<?> clazz, String pathname) {
        return StreamUtil.getStream(StreamUtil.findFile(clazz, pathname));
    }

    public static InputStream getStream(String filepath) {
        return StreamUtil.getStream(new File(filepath));
    }

    public static InputStream getStream(File file) {
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static BufferedReader loadString(String str) {
        return new BufferedReader(new StringReader(str));
    }

    public static BufferedReader loadReader(InputStream is) {
        return new BufferedReader(new InputStreamReader(is));
    }

    public static BufferedReader loadReader(InputStream is, Charset charset) {
        return new BufferedReader(new InputStreamReader(is, charset));
    }

    public static void exportOutputStream(byte[] bytes, OutputStream os) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        bos.write(bytes);
        bos.flush();
    }

    public static String readerToString(BufferedReader reader, boolean lineStrip, boolean ignoreNewLine) throws IOException {
        try (BufferedReader bufferedReader = reader;){
            String string = StreamUtil.readerTo(reader, lineStrip, ignoreNewLine ? null : Environment.NEW_LINE);
            return string;
        }
    }

    public static String readerTo(BufferedReader reader, boolean lineStrip, String newLine) {
        StringBuilder sb = new StringBuilder();
        ArrayList lines = reader.lines().collect(Collectors.toCollection(ArrayList::new));
        for (String line : lines) {
            if (lineStrip) {
                line = line.strip();
            }
            sb.append(line);
            if (newLine == null) continue;
            sb.append(newLine);
        }
        return sb.toString();
    }

    public static String readerToString(BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (reader.ready()) {
            sb.append((char)reader.read());
        }
        reader.close();
        return sb.toString();
    }

    public static Reader readFile(String pathname) throws IOException {
        return StreamUtil.readFile(new File(pathname));
    }

    public static Reader readFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("Can not found file");
        }
        if (!file.canRead()) {
            throw new IOException("Can not read file");
        }
        return new FileReader(file);
    }

    public static Writer writeFile(String pathname) throws IOException {
        return StreamUtil.writeFile(new File(pathname));
    }

    public static Writer writeFile(File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Can not create file");
        }
        if (!file.canWrite()) {
            throw new IOException("Can not write file");
        }
        return new FileWriter(file);
    }

    public static void writeFile(byte[] b, File file) throws IOException {
        StreamUtil.writeFile(b, file, false);
    }

    public static void writeFile(byte[] b, File file, boolean append) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Can not create file");
        }
        if (!file.canWrite()) {
            throw new IOException("Can not write file");
        }
        FileOutputStream os = new FileOutputStream(file, append);
        StreamUtil.exportOutputStream(b, os);
        ((OutputStream)os).close();
    }
}

