/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.util.zip.CRC32C;
import org.seppiko.commons.utils.Environment;
import org.seppiko.commons.utils.MathUtil;
import org.seppiko.commons.utils.crypto.CRC16MAXIM;
import org.seppiko.commons.utils.crypto.CRC64ECMA182;

public class CRCUtil {

    public static class CRC64E {
        private static CRC64ECMA182 crc64e = new CRC64ECMA182();

        public static long encode(byte[] data) {
            crc64e.update(data);
            return crc64e.getValue();
        }

        public static String encodeString(byte[] data) {
            long crc64 = CRC64E.encode(data);
            return MathUtil.convertDecimalTo(crc64, Environment.HEXADECIMAL);
        }
    }

    public static class CRC32 {
        private static CRC32C crc32 = new CRC32C();

        public static long encode(byte[] data) {
            crc32.update(data);
            return crc32.getValue();
        }

        public static String encodeString(byte[] data) {
            long crc32 = CRC32.encode(data);
            return MathUtil.convertDecimalTo(crc32, Environment.HEXADECIMAL);
        }
    }

    public static class CRC16M {
        private static CRC16MAXIM crc16MAXIM = new CRC16MAXIM();

        public static long encode(byte[] data) {
            crc16MAXIM.update(data);
            return crc16MAXIM.getValue();
        }

        public static String encodeString(byte[] data) {
            long crc16 = CRC16M.encode(data);
            return MathUtil.convertDecimalTo(crc16, Environment.HEXADECIMAL);
        }
    }
}

