/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.seppiko.commons.utils.crypto.CryptoUtil;

public class SignatureUtil {
    public static Signature signature(String algorithm) throws NoSuchAlgorithmException, NullPointerException {
        return Signature.getInstance(algorithm);
    }

    public static Signature signature(String algorithm, Provider provider) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException {
        if (provider == CryptoUtil.NONPROVIDER) {
            return SignatureUtil.signature(algorithm);
        }
        return Signature.getInstance(algorithm, provider);
    }

    public static byte[] signatureSign(String algorithm, PrivateKey privateKey, byte[] rawData) throws NoSuchAlgorithmException, NullPointerException, InvalidKeyException, SignatureException {
        return SignatureUtil.signatureSign(algorithm, CryptoUtil.NONPROVIDER, privateKey, rawData);
    }

    public static boolean signatureVerify(String algorithm, PublicKey publicKey, byte[] rawData, byte[] signedData) throws NoSuchAlgorithmException, NullPointerException, InvalidKeyException, SignatureException {
        return SignatureUtil.signatureVerify(algorithm, CryptoUtil.NONPROVIDER, publicKey, rawData, signedData);
    }

    public static byte[] signatureSign(String algorithm, Provider provider, PrivateKey privateKey, byte[] rawData) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException, InvalidKeyException, SignatureException {
        Signature signature = SignatureUtil.signature(algorithm, provider);
        signature.initSign(privateKey);
        signature.update(rawData);
        return signature.sign();
    }

    public static boolean signatureVerify(String algorithm, Provider provider, PublicKey publicKey, byte[] rawData, byte[] signedData) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException, InvalidKeyException, SignatureException {
        Signature signature = SignatureUtil.signature(algorithm, provider);
        signature.initVerify(publicKey);
        signature.update(rawData);
        return signature.verify(signedData);
    }
}

