/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import org.seppiko.commons.utils.StringUtil;
import org.seppiko.commons.utils.http.HttpCookie;

public class HttpHeaders {
    private final LinkedHashMap<String, ArrayList<String>> headers = new LinkedHashMap();
    private final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char HTTP_HEADER_VALUE_SEPARTOR = ';';

    private HttpHeaders() {
    }

    public static HttpHeaders newHeaders() {
        return new HttpHeaders();
    }

    public HttpHeaders setHeaders(String name, String ... values) {
        this.headers.put(name, new ArrayList<String>(Arrays.asList(values)));
        return this;
    }

    public HttpHeaders setCookie(HttpCookie ... cookies) {
        ArrayList cookieString = new ArrayList();
        Arrays.asList(cookies).forEach(cookie -> cookieString.add(cookie.toString()));
        this.setHeaders("Cookie", (String[])cookieString.toArray(String[]::new));
        return this;
    }

    public HttpHeaders addHeaders(String name, String ... values) throws IllegalArgumentException {
        if (this.headers.containsKey(name)) {
            ArrayList<String> valueOld = this.headers.get(name);
            ArrayList<String> valueNew = new ArrayList<String>(Arrays.asList(values));
            for (String value : valueOld) {
                if (valueNew.contains(value)) continue;
                try {
                    valueNew.add(value);
                }
                catch (ClassCastException | IllegalArgumentException | NullPointerException | UnsupportedOperationException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            this.headers.put(name, valueNew);
        } else {
            this.setHeaders(name, values);
        }
        return this;
    }

    public String[] getHeaderList() throws IllegalCallerException, IllegalArgumentException {
        return this.headers.isEmpty() ? this.EMPTY_STRING_ARRAY : this.headerHeadler(this.headers);
    }

    private String[] headerHeadler(LinkedHashMap<String, ArrayList<String>> headerMap) throws IllegalCallerException, IllegalArgumentException {
        ArrayList headerList = new ArrayList();
        try {
            headerMap.forEach((key, value) -> {
                headerList.add(key);
                headerList.add(this.valuesHeadler((ArrayList<String>)value));
            });
            return (String[])headerList.toArray(String[]::new);
        }
        catch (ArrayStoreException | ClassCastException | ConcurrentModificationException ex) {
            throw new IllegalCallerException(ex);
        }
        catch (IllegalArgumentException | UnsupportedOperationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (NullPointerException nullPointerException) {
            return this.EMPTY_STRING_ARRAY;
        }
    }

    private String valuesHeadler(ArrayList<String> valueList) {
        return StringUtil.convertJoinerString("; ", (String[])valueList.toArray(String[]::new));
    }
}

