/*
 * Copyright 2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.utils.codec;

/**
 * Abstract superclass for Base-N encoders and decoders.
 *
 * @author Leonard Woo
 */
public abstract class BaseNCodec {

  /** Mask used to extract 8 bits, used in decoding bytes */
  protected static final long MASK_8BITS = 0xFFL;
  /** Mask used to extract 5 bits, used when encoding bytes */
  protected static final long MASK_5BITS = 0x1FL;
  /** Mask used to extract 4 bits, used when decoding character. */
  protected static final long MASK_4BITS = 0x0FL;

  public abstract String encode(final byte[] data);

  public abstract byte[] decode(final String str) throws IllegalArgumentException, NullPointerException;
}
