/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.glf.api;

/**
 * Logger
 *
 * @author Leonard Woo
 */
public interface Logger {

  String getName();

  boolean isTraceEnabled();

  boolean isTraceEnabled(Marker marker);

  void trace(String message);

  void trace(String message, Object param);

  void trace(String message, Object... params);

  void trace(String message, Throwable cause);

  void trace(String message, Object param, Throwable cause);

  void trace(String message, Object[] params, Throwable cause);

  void trace(Marker marker, String message);

  void trace(Marker marker, String message, Object param);

  void trace(Marker marker, String message, Object... params);

  void trace(Marker marker, String message, Throwable cause);

  void trace(Marker marker, String message, Object param, Throwable cause);

  void trace(Marker marker, String message, Object[] params, Throwable cause);

  boolean isDebugEnabled();

  boolean isDebugEnabled(Marker marker);

  void debug(String message);

  void debug(String message, Object param);

  void debug(String message, Object... params);

  void debug(String message, Throwable cause);

  void debug(String message, Object param, Throwable cause);

  void debug(String message, Object[] params, Throwable cause);

  void debug(Marker marker, String message);

  void debug(Marker marker, String message, Object param);

  void debug(Marker marker, String message, Object... params);

  void debug(Marker marker, String message, Throwable cause);

  void debug(Marker marker, String message, Object param, Throwable cause);

  void debug(Marker marker, String message, Object[] params, Throwable cause);

  boolean isInfoEnabled();

  boolean isInfoEnabled(Marker marker);

  void info(String message);

  void info(String message, Object param);

  void info(String message, Object... params);

  void info(String message, Throwable cause);

  void info(String message, Object param, Throwable cause);

  void info(String message, Object[] params, Throwable cause);

  void info(Marker marker, String message);

  void info(Marker marker, String message, Object param);

  void info(Marker marker, String message, Object... params);

  void info(Marker marker, String message, Throwable cause);

  void info(Marker marker, String message, Object param, Throwable cause);

  void info(Marker marker, String message, Object[] params, Throwable cause);

  boolean isWarnEnabled();

  boolean isWarnEnabled(Marker marker);

  void warn(String message);

  void warn(String message, Object param);

  void warn(String message, Object... params);

  void warn(String message, Throwable cause);

  void warn(String message, Object param, Throwable cause);

  void warn(String message, Object[] params, Throwable cause);

  void warn(Marker marker, String message);

  void warn(Marker marker, String message, Object param);

  void warn(Marker marker, String message, Object... params);

  void warn(Marker marker, String message, Throwable cause);

  void warn(Marker marker, String message, Object param, Throwable cause);

  void warn(Marker marker, String message, Object[] params, Throwable cause);

  boolean isErrorEnabled();

  boolean isErrorEnabled(Marker marker);

  void error(String message);

  void error(String message, Object param);

  void error(String message, Object... params);

  void error(String message, Throwable cause);

  void error(String message, Object param, Throwable cause);

  void error(String message, Object[] params, Throwable cause);

  void error(Marker marker, String message);

  void error(Marker marker, String message, Object param);

  void error(Marker marker, String message, Object... params);

  void error(Marker marker, String message, Throwable cause);

  void error(Marker marker, String message, Object param, Throwable cause);

  void error(Marker marker, String message, Object[] params, Throwable cause);

  boolean isFatalEnabled();

  boolean isFatalEnabled(Marker marker);

  void fatal(String message);

  void fatal(String message, Object param);

  void fatal(String message, Object... params);

  void fatal(String message, Throwable cause);

  void fatal(String message, Object param, Throwable cause);

  void fatal(String message, Object[] params, Throwable cause);

  void fatal(Marker marker, String message);

  void fatal(Marker marker, String message, Object param);

  void fatal(Marker marker, String message, Object... params);

  void fatal(Marker marker, String message, Throwable cause);

  void fatal(Marker marker, String message, Object param, Throwable cause);

  void fatal(Marker marker, String message, Object[] params, Throwable cause);
}
