/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.glf.event;

import org.seppiko.glf.api.IMarkerFactory;
import org.seppiko.glf.api.LoggerFactory;
import org.seppiko.glf.api.Marker;
import org.seppiko.glf.spi.GLFServiceProvider;
import org.seppiko.glf.utils.GLFReport;

/**
 * Marker factory
 *
 * @author Leonard Woo
 */
public class DefaultMarkerFactory {

  private static IMarkerFactory MARKER_FACTORY;

  public DefaultMarkerFactory() {
  }

  static {
    GLFServiceProvider serviceProvider = LoggerFactory.getServiceProvider();
    if (serviceProvider != null) {
      MARKER_FACTORY = serviceProvider.getMarkerFactory();
    } else {
      GLFReport.err("Failed to find provider");
    }
  }

  public Marker getMarker(String name) {
    return MARKER_FACTORY.getMarker(name);
  }

  public Marker getDetachedMarker(String name) {
    return MARKER_FACTORY.getDetachedMarker(name);
  }

  public static IMarkerFactory getIMarkerFactory() {
    return MARKER_FACTORY;
  }

}
