/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.glf.api;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.seppiko.glf.api.ILoggerFactory;
import org.seppiko.glf.api.Logger;
import org.seppiko.glf.event.DefaultLogger;
import org.seppiko.glf.event.DefaultServiceProvider;
import org.seppiko.glf.event.nop.NOPServiceProvider;
import org.seppiko.glf.spi.GLFServiceProvider;
import org.seppiko.glf.utils.GLFReport;

public final class LoggerFactory {
    static volatile GLFServiceProvider PROVIDER;
    private static final int UNINITIALIZED = 0;
    private static final int ONGOING_INITIALIZATION = 1;
    private static final int FAILED_INITIALIZATION = 2;
    private static final int SUCCESSFUL_INITIALIZATION = 3;
    private static final int NOP_PROVIDER_INITIALIZATION = 4;
    private static volatile int STATUS;
    private static final DefaultServiceProvider DEFAULT_PROVIDER;
    private static final NOPServiceProvider NOP_PROVIDER;
    private static final String STATIC_LOGGER_BINDER = "org/seppiko/glf/impl/StaticLoggerBinder.class";

    public static Logger getLogger(String name) {
        return LoggerFactory.getLoggerFactory().getLogger(name);
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static ILoggerFactory getLoggerFactory() {
        return LoggerFactory.getServiceProvider().getILoggerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static GLFServiceProvider getServiceProvider() {
        if (STATUS == 0) {
            Class<LoggerFactory> clazz = LoggerFactory.class;
            // MONITORENTER : org.seppiko.glf.api.LoggerFactory.class
            if (STATUS == 0) {
                STATUS = 1;
                LoggerFactory.bind();
            }
            // MONITOREXIT : clazz
        }
        switch (STATUS) {
            case 3: {
                return PROVIDER;
            }
            case 4: {
                return NOP_PROVIDER;
            }
            case 2: {
                throw new IllegalStateException("LoggerFactory in failed state. Original exception was thrown EARLIER.");
            }
            case 1: {
                return DEFAULT_PROVIDER;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bind() {
        try {
            List<GLFServiceProvider> providers = LoggerFactory.findGLFServiceProvider();
            if (providers.size() > 1) {
                GLFReport.err("Class path contains multiple GLF providers.");
                for (GLFServiceProvider provider : providers) {
                    GLFReport.err("Found provider [" + provider + "]");
                }
            }
            if (!providers.isEmpty()) {
                PROVIDER = providers.get(0);
                PROVIDER.initialize();
                STATUS = 3;
                if (providers.size() > 1) {
                    GLFReport.info("Actual provider is of type [" + providers.get(0) + "]");
                }
            } else {
                STATUS = 4;
                GLFReport.err("No GLF service providers were found.");
                GLFReport.err("Defaulting to no-operation (NOP) logger implementation");
                Set<URL> staticLoggerBinderPathSet = LoggerFactory.findPossibleStaticLoggerBinderPathSet();
                LoggerFactory.reportIgnoredStaticLoggerBinders(staticLoggerBinderPathSet);
            }
            DefaultServiceProvider defaultServiceProvider = DEFAULT_PROVIDER;
            synchronized (defaultServiceProvider) {
                for (DefaultLogger defaultLogger : DEFAULT_PROVIDER.getLoggerFactory().getLoggers()) {
                    Logger logger = LoggerFactory.getLogger(defaultLogger.getName());
                    defaultLogger.setDelegate(logger);
                }
            }
            DEFAULT_PROVIDER.getLoggerFactory().clear();
        }
        catch (Exception e) {
            STATUS = 2;
            GLFReport.err("Failed to instantiate GLF LoggerFactory", e);
            throw new IllegalStateException("Unexpected initialization failure", e);
        }
    }

    private static List<GLFServiceProvider> findGLFServiceProvider() {
        ServiceLoader<GLFServiceProvider> loader = ServiceLoader.load(GLFServiceProvider.class);
        ArrayList<GLFServiceProvider> providers = new ArrayList<GLFServiceProvider>();
        loader.forEach(providers::add);
        return providers;
    }

    static Set<URL> findPossibleStaticLoggerBinderPathSet() {
        LinkedHashSet<URL> staticLoggerBinderPathSet = new LinkedHashSet<URL>();
        try {
            ClassLoader loggerFactoryClassLoader = LoggerFactory.class.getClassLoader();
            Enumeration<URL> paths = loggerFactoryClassLoader == null ? ClassLoader.getSystemResources(STATIC_LOGGER_BINDER) : loggerFactoryClassLoader.getResources(STATIC_LOGGER_BINDER);
            while (paths.hasMoreElements()) {
                URL path = paths.nextElement();
                staticLoggerBinderPathSet.add(path);
            }
        }
        catch (IOException ioe) {
            GLFReport.err("Error getting resources from path", ioe);
        }
        return staticLoggerBinderPathSet;
    }

    private static void reportIgnoredStaticLoggerBinders(Set<URL> staticLoggerBinderPathSet) {
        if (staticLoggerBinderPathSet.isEmpty()) {
            return;
        }
        GLFReport.err("Class path contains GLF bindings targeting glf-api.");
        for (URL path : staticLoggerBinderPathSet) {
            GLFReport.err("Ignoring binding found at [" + path + "]");
        }
    }

    static {
        STATUS = 0;
        DEFAULT_PROVIDER = new DefaultServiceProvider();
        NOP_PROVIDER = new NOPServiceProvider();
    }
}

