/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.glf.event;

import org.seppiko.glf.api.Level;
import org.seppiko.glf.api.Logger;
import org.seppiko.glf.api.Marker;

public abstract class AbstractLogger
implements Logger {
    protected String name;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.trace(message, (Object)null);
        }
    }

    @Override
    public void trace(String message, Object param) {
        if (this.isTraceEnabled()) {
            this.trace(message, param, null);
        }
    }

    @Override
    public void trace(String message, Object ... params) {
        if (this.isTraceEnabled()) {
            this.trace(message, params, (Throwable)null);
        }
    }

    @Override
    public void trace(String message, Throwable cause) {
        if (this.isTraceEnabled()) {
            this.trace(message, (Object[])null, cause);
        }
    }

    @Override
    public void trace(String message, Object param, Throwable cause) {
        if (this.isTraceEnabled()) {
            this.trace(message, new Object[]{param}, cause);
        }
    }

    @Override
    public void trace(String message, Object[] params, Throwable cause) {
        if (this.isTraceEnabled()) {
            this.trace((Marker)null, message, params, cause);
        }
    }

    @Override
    public void trace(Marker marker, String message) {
        if (this.isTraceEnabled(marker)) {
            this.trace(marker, message, (Object)null);
        }
    }

    @Override
    public void trace(Marker marker, String message, Object param) {
        if (this.isTraceEnabled(marker)) {
            this.trace(marker, message, param, null);
        }
    }

    @Override
    public void trace(Marker marker, String message, Object ... params) {
        if (this.isTraceEnabled(marker)) {
            this.trace(marker, message, params, (Throwable)null);
        }
    }

    @Override
    public void trace(Marker marker, String message, Throwable cause) {
        if (this.isTraceEnabled(marker)) {
            this.trace(marker, message, (Object[])null, cause);
        }
    }

    @Override
    public void trace(Marker marker, String message, Object param, Throwable cause) {
        if (this.isTraceEnabled(marker)) {
            this.trace(marker, message, new Object[]{param}, cause);
        }
    }

    @Override
    public void trace(Marker marker, String message, Object[] params, Throwable cause) {
        if (this.isTraceEnabled(marker)) {
            this.handleNormalizedLoggingCall(Level.TRACE, marker, message, params, cause);
        }
    }

    @Override
    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.debug(message, (Object)null);
        }
    }

    @Override
    public void debug(String message, Object param) {
        if (this.isDebugEnabled()) {
            this.debug(message, param, null);
        }
    }

    @Override
    public void debug(String message, Object ... params) {
        if (this.isDebugEnabled()) {
            this.debug(message, params, (Throwable)null);
        }
    }

    @Override
    public void debug(String message, Throwable cause) {
        if (this.isDebugEnabled()) {
            this.debug(message, (Object[])null, cause);
        }
    }

    @Override
    public void debug(String message, Object param, Throwable cause) {
        if (this.isDebugEnabled()) {
            this.debug(message, new Object[]{param}, cause);
        }
    }

    @Override
    public void debug(String message, Object[] params, Throwable cause) {
        if (this.isDebugEnabled()) {
            this.debug((Marker)null, message, params, cause);
        }
    }

    @Override
    public void debug(Marker marker, String message) {
        if (this.isDebugEnabled(marker)) {
            this.debug(marker, message, (Object)null);
        }
    }

    @Override
    public void debug(Marker marker, String message, Object param) {
        if (this.isDebugEnabled(marker)) {
            this.debug(marker, message, param, null);
        }
    }

    @Override
    public void debug(Marker marker, String message, Object ... params) {
        if (this.isDebugEnabled(marker)) {
            this.debug(marker, message, params, (Throwable)null);
        }
    }

    @Override
    public void debug(Marker marker, String message, Throwable cause) {
        if (this.isDebugEnabled(marker)) {
            this.debug(marker, message, (Object[])null, cause);
        }
    }

    @Override
    public void debug(Marker marker, String message, Object param, Throwable cause) {
        if (this.isDebugEnabled(marker)) {
            this.debug(marker, message, new Object[]{param}, cause);
        }
    }

    @Override
    public void debug(Marker marker, String message, Object[] params, Throwable cause) {
        if (this.isDebugEnabled(marker)) {
            this.handleNormalizedLoggingCall(Level.DEBUG, marker, message, params, cause);
        }
    }

    @Override
    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.info(message, (Object)null);
        }
    }

    @Override
    public void info(String message, Object param) {
        if (this.isInfoEnabled()) {
            this.info(message, param, null);
        }
    }

    @Override
    public void info(String message, Object ... params) {
        if (this.isInfoEnabled()) {
            this.info(message, params, (Throwable)null);
        }
    }

    @Override
    public void info(String message, Throwable cause) {
        if (this.isInfoEnabled()) {
            this.info(message, (Object[])null, cause);
        }
    }

    @Override
    public void info(String message, Object param, Throwable cause) {
        if (this.isInfoEnabled()) {
            this.info(message, new Object[]{param}, cause);
        }
    }

    @Override
    public void info(String message, Object[] params, Throwable cause) {
        if (this.isInfoEnabled()) {
            this.info((Marker)null, message, params, cause);
        }
    }

    @Override
    public void info(Marker marker, String message) {
        if (this.isInfoEnabled(marker)) {
            this.info(marker, message, (Object)null);
        }
    }

    @Override
    public void info(Marker marker, String message, Object param) {
        if (this.isInfoEnabled(marker)) {
            this.info(marker, message, param, null);
        }
    }

    @Override
    public void info(Marker marker, String message, Object ... params) {
        if (this.isInfoEnabled(marker)) {
            this.info(marker, message, params, (Throwable)null);
        }
    }

    @Override
    public void info(Marker marker, String message, Throwable cause) {
        if (this.isInfoEnabled(marker)) {
            this.info(marker, message, (Object[])null, cause);
        }
    }

    @Override
    public void info(Marker marker, String message, Object param, Throwable cause) {
        if (this.isInfoEnabled(marker)) {
            this.info(marker, message, new Object[]{param}, cause);
        }
    }

    @Override
    public void info(Marker marker, String message, Object[] params, Throwable cause) {
        if (this.isInfoEnabled(marker)) {
            this.handleNormalizedLoggingCall(Level.INFO, marker, message, params, cause);
        }
    }

    @Override
    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.warn(message, (Object)null);
        }
    }

    @Override
    public void warn(String message, Object param) {
        if (this.isWarnEnabled()) {
            this.warn(message, param, null);
        }
    }

    @Override
    public void warn(String message, Object ... params) {
        if (this.isWarnEnabled()) {
            this.warn(message, params, (Throwable)null);
        }
    }

    @Override
    public void warn(String message, Throwable cause) {
        if (this.isWarnEnabled()) {
            this.warn(message, (Object[])null, cause);
        }
    }

    @Override
    public void warn(String message, Object param, Throwable cause) {
        if (this.isWarnEnabled()) {
            this.warn(message, new Object[]{param}, cause);
        }
    }

    @Override
    public void warn(String message, Object[] params, Throwable cause) {
        if (this.isWarnEnabled()) {
            this.warn((Marker)null, message, params, cause);
        }
    }

    @Override
    public void warn(Marker marker, String message) {
        if (this.isWarnEnabled(marker)) {
            this.warn(marker, message, (Object)null);
        }
    }

    @Override
    public void warn(Marker marker, String message, Object param) {
        if (this.isWarnEnabled(marker)) {
            this.warn(marker, message, param, null);
        }
    }

    @Override
    public void warn(Marker marker, String message, Object ... params) {
        if (this.isWarnEnabled(marker)) {
            this.warn(marker, message, params, (Throwable)null);
        }
    }

    @Override
    public void warn(Marker marker, String message, Throwable cause) {
        if (this.isWarnEnabled(marker)) {
            this.warn(marker, message, (Object[])null, cause);
        }
    }

    @Override
    public void warn(Marker marker, String message, Object param, Throwable cause) {
        if (this.isWarnEnabled(marker)) {
            this.warn(marker, message, new Object[]{param}, cause);
        }
    }

    @Override
    public void warn(Marker marker, String message, Object[] params, Throwable cause) {
        if (this.isWarnEnabled(marker)) {
            this.handleNormalizedLoggingCall(Level.WARN, marker, message, params, cause);
        }
    }

    @Override
    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.error(message, (Object)null);
        }
    }

    @Override
    public void error(String message, Object param) {
        if (this.isErrorEnabled()) {
            this.error(message, param, null);
        }
    }

    @Override
    public void error(String message, Object ... params) {
        if (this.isErrorEnabled()) {
            this.error(message, params, (Throwable)null);
        }
    }

    @Override
    public void error(String message, Throwable cause) {
        if (this.isErrorEnabled()) {
            this.error(message, (Object[])null, cause);
        }
    }

    @Override
    public void error(String message, Object param, Throwable cause) {
        if (this.isErrorEnabled()) {
            this.error(message, new Object[]{param}, cause);
        }
    }

    @Override
    public void error(String message, Object[] params, Throwable cause) {
        if (this.isErrorEnabled()) {
            this.error((Marker)null, message, params, cause);
        }
    }

    @Override
    public void error(Marker marker, String message) {
        if (this.isErrorEnabled(marker)) {
            this.error(marker, message, (Object)null);
        }
    }

    @Override
    public void error(Marker marker, String message, Object param) {
        if (this.isErrorEnabled(marker)) {
            this.error(marker, message, param, null);
        }
    }

    @Override
    public void error(Marker marker, String message, Object ... params) {
        if (this.isErrorEnabled(marker)) {
            this.error(marker, message, params, (Throwable)null);
        }
    }

    @Override
    public void error(Marker marker, String message, Throwable cause) {
        if (this.isErrorEnabled(marker)) {
            this.error(marker, message, (Object[])null, cause);
        }
    }

    @Override
    public void error(Marker marker, String message, Object param, Throwable cause) {
        if (this.isErrorEnabled(marker)) {
            this.error(marker, message, new Object[]{param}, cause);
        }
    }

    @Override
    public void error(Marker marker, String message, Object[] params, Throwable cause) {
        if (this.isErrorEnabled(marker)) {
            this.handleNormalizedLoggingCall(Level.ERROR, marker, message, params, cause);
        }
    }

    @Override
    public void fatal(String message) {
        if (this.isFatalEnabled()) {
            this.fatal(message, (Object)null);
        }
    }

    @Override
    public void fatal(String message, Object param) {
        if (this.isFatalEnabled()) {
            this.fatal(message, param, null);
        }
    }

    @Override
    public void fatal(String message, Object ... params) {
        if (this.isFatalEnabled()) {
            this.fatal(message, params, (Throwable)null);
        }
    }

    @Override
    public void fatal(String message, Throwable cause) {
        if (this.isFatalEnabled()) {
            this.fatal(message, (Object[])null, cause);
        }
    }

    @Override
    public void fatal(String message, Object param, Throwable cause) {
        if (this.isFatalEnabled()) {
            this.fatal(message, new Object[]{param}, cause);
        }
    }

    @Override
    public void fatal(String message, Object[] params, Throwable cause) {
        if (this.isFatalEnabled()) {
            this.fatal((Marker)null, message, params, cause);
        }
    }

    @Override
    public void fatal(Marker marker, String message) {
        if (this.isFatalEnabled(marker)) {
            this.fatal(marker, message, (Object)null);
        }
    }

    @Override
    public void fatal(Marker marker, String message, Object param) {
        if (this.isFatalEnabled(marker)) {
            this.fatal(marker, message, param, null);
        }
    }

    @Override
    public void fatal(Marker marker, String message, Object ... params) {
        if (this.isFatalEnabled(marker)) {
            this.fatal(marker, message, params, (Throwable)null);
        }
    }

    @Override
    public void fatal(Marker marker, String message, Throwable cause) {
        if (this.isFatalEnabled(marker)) {
            this.fatal(marker, message, (Object[])null, cause);
        }
    }

    @Override
    public void fatal(Marker marker, String message, Object param, Throwable cause) {
        if (this.isFatalEnabled(marker)) {
            this.fatal(marker, message, new Object[]{param}, cause);
        }
    }

    @Override
    public void fatal(Marker marker, String message, Object[] params, Throwable cause) {
        if (this.isFatalEnabled(marker)) {
            this.handleNormalizedLoggingCall(Level.TRACE, marker, message, params, cause);
        }
    }

    protected abstract String getFullyQualifiedCallerName();

    protected abstract void handleNormalizedLoggingCall(Level var1, Marker var2, String var3, Object[] var4, Throwable var5);
}

