/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.glf.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.seppiko.glf.api.ILoggerFactory;
import org.seppiko.glf.api.Logger;
import org.seppiko.glf.event.DefaultLogger;

public class BasicLoggerFactory
implements ILoggerFactory {
    final Map<String, DefaultLogger> loggers = new ConcurrentHashMap<String, DefaultLogger>();

    @Override
    public Logger getLogger(String name) {
        DefaultLogger logger = this.loggers.get(name);
        if (logger == null) {
            logger = new DefaultLogger(name);
            this.loggers.put(name, logger);
        }
        return logger;
    }

    public List<String> getLoggerNames() {
        return new ArrayList<String>(this.loggers.keySet());
    }

    public List<DefaultLogger> getLoggers() {
        return new ArrayList<DefaultLogger>(this.loggers.values());
    }

    public void clear() {
        this.loggers.clear();
    }
}

