/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.glf.api;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.seppiko.glf.api.ILoggerFactory;
import org.seppiko.glf.api.Logger;
import org.seppiko.glf.event.DefaultLogger;
import org.seppiko.glf.event.DefaultServiceProvider;
import org.seppiko.glf.event.nop.NOPServiceProvider;
import org.seppiko.glf.spi.GLFServiceProvider;
import org.seppiko.glf.utils.GLFReport;

public final class LoggerFactory {
    static volatile GLFServiceProvider PROVIDER;
    private static volatile status STATUS;
    private static final DefaultServiceProvider DEFAULT_PROVIDER;
    private static final NOPServiceProvider NOP_PROVIDER;

    private LoggerFactory() {
    }

    public static Logger getLogger(String name) {
        return LoggerFactory.getLoggerFactory().getLogger(name);
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static ILoggerFactory getLoggerFactory() {
        return LoggerFactory.getServiceProvider().getILoggerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static GLFServiceProvider getServiceProvider() {
        if (STATUS == status.UNINITIALIZED) {
            Class<LoggerFactory> clazz = LoggerFactory.class;
            // MONITORENTER : org.seppiko.glf.api.LoggerFactory.class
            if (STATUS == status.UNINITIALIZED) {
                STATUS = status.ONGOING_INITIALIZATION;
                LoggerFactory.bind();
            }
            // MONITOREXIT : clazz
        }
        switch (STATUS.ordinal()) {
            case 3: {
                GLFServiceProvider gLFServiceProvider = PROVIDER;
                return gLFServiceProvider;
            }
            case 4: {
                GLFServiceProvider gLFServiceProvider = NOP_PROVIDER;
                return gLFServiceProvider;
            }
            case 2: {
                throw new IllegalStateException("LoggerFactory in failed state. Original exception was thrown EARLIER.");
            }
            case 1: {
                GLFServiceProvider gLFServiceProvider = DEFAULT_PROVIDER;
                return gLFServiceProvider;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bind() {
        try {
            List<GLFServiceProvider> providers = LoggerFactory.findGLFServiceProvider();
            if (providers.size() > 1) {
                GLFReport.err("Class path contains multiple GLF providers.");
                for (GLFServiceProvider provider : providers) {
                    GLFReport.err("Found provider [" + String.valueOf(provider) + "]");
                }
            }
            if (!providers.isEmpty()) {
                PROVIDER = providers.get(0);
                PROVIDER.initialize();
                STATUS = status.SUCCESSFUL_INITIALIZATION;
                if (providers.size() > 1) {
                    GLFReport.info("Actual provider is of type [" + String.valueOf(providers.get(0)) + "]");
                }
            } else {
                STATUS = status.NOP_PROVIDER_INITIALIZATION;
                GLFReport.err("No GLF service providers were found.");
                GLFReport.err("Defaulting to no-operation (NOP) logger implementation");
            }
            DefaultServiceProvider defaultServiceProvider = DEFAULT_PROVIDER;
            synchronized (defaultServiceProvider) {
                for (DefaultLogger defaultLogger : DEFAULT_PROVIDER.getLoggerFactory().getLoggers()) {
                    Logger logger = LoggerFactory.getLogger(defaultLogger.getName());
                    defaultLogger.setDelegate(logger);
                }
            }
            DEFAULT_PROVIDER.getLoggerFactory().clear();
        }
        catch (Exception e) {
            STATUS = status.FAILED_INITIALIZATION;
            GLFReport.err("Failed to instantiate GLF LoggerFactory", e);
            throw new IllegalStateException("Unexpected initialization failure", e);
        }
    }

    private static List<GLFServiceProvider> findGLFServiceProvider() {
        ServiceLoader<GLFServiceProvider> loader = ServiceLoader.load(GLFServiceProvider.class);
        ArrayList<GLFServiceProvider> providers = new ArrayList<GLFServiceProvider>();
        loader.forEach(providers::add);
        return providers;
    }

    static {
        STATUS = status.UNINITIALIZED;
        DEFAULT_PROVIDER = new DefaultServiceProvider();
        NOP_PROVIDER = new NOPServiceProvider();
    }

    private static enum status {
        UNINITIALIZED(0),
        ONGOING_INITIALIZATION(1),
        FAILED_INITIALIZATION(2),
        SUCCESSFUL_INITIALIZATION(3),
        NOP_PROVIDER_INITIALIZATION(4);

        final int code;

        private status(int code) {
            this.code = code;
        }
    }
}

