/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.glf.event;

import java.util.ArrayList;
import java.util.function.Supplier;
import org.seppiko.glf.api.Level;
import org.seppiko.glf.api.Logger;
import org.seppiko.glf.api.Marker;
import org.seppiko.glf.event.LoggerEventBuilder;

public class DefaultLoggerEventBuilder
implements LoggerEventBuilder {
    private final Logger logger;
    private final Level level;
    private Marker marker;
    private String message;
    private Throwable cause;
    private final ArrayList<Object> params = new ArrayList();

    public DefaultLoggerEventBuilder(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
    }

    @Override
    public LoggerEventBuilder marker(Marker marker) {
        this.marker = marker;
        return this;
    }

    @Override
    public LoggerEventBuilder message(String message) {
        this.message = message;
        return this;
    }

    @Override
    public LoggerEventBuilder withCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    @Override
    public LoggerEventBuilder addParam(Supplier<?> paramSupplier) {
        this.params.add(paramSupplier.get());
        return this;
    }

    @Override
    public LoggerEventBuilder addParam(Object paramObject) {
        this.params.add(paramObject);
        return this;
    }

    @Override
    public void log() {
        Object[] objects = this.params.toArray(Object[]::new);
        this.log(this.level, this.marker, this.message, objects, this.cause);
    }

    private void log(Level level, Marker marker, String message, Object[] objects, Throwable cause) {
        switch (level) {
            case TRACE: {
                this.logger.trace(marker, message, objects, cause);
                break;
            }
            case DEBUG: {
                this.logger.debug(marker, message, objects, cause);
                break;
            }
            case INFO: {
                this.logger.info(marker, message, objects, cause);
                break;
            }
            case WARN: {
                this.logger.warn(marker, message, objects, cause);
                break;
            }
            case ERROR: {
                this.logger.error(marker, message, objects, cause);
                break;
            }
            case FATAL: {
                this.logger.fatal(marker, message, objects, cause);
            }
        }
    }
}

