/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.glf.log4j2;

import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.seppiko.glf.api.Level;
import org.seppiko.glf.api.LocationLogger;
import org.seppiko.glf.api.Marker;
import org.seppiko.glf.impl.StaticMarkerBinder;
import org.seppiko.glf.log4j2.Log4j2Marker;
import org.seppiko.glf.log4j2.Log4j2MarkerFactory;

public class Log4j2Logger
implements LocationLogger {
    public static final String FQCN = Log4j2Logger.class.getName();
    private transient ExtendedLogger logger;
    private final String name;

    public Log4j2Logger(ExtendedLogger logger, String name) {
        this.logger = logger;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.TRACE, null, null);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.TRACE, Log4j2Logger.getMarker(marker), null);
    }

    public void trace(String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, null, message);
    }

    public void trace(String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, null, message, param);
    }

    public void trace(String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, null, message, params);
    }

    public void trace(String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, null, message, cause);
    }

    public void trace(String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, null, message, param, (Object)cause);
    }

    public void trace(String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, null, message, (Object)params, (Object)cause);
    }

    public void trace(Marker marker, String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, Log4j2Logger.getMarker(marker), message);
    }

    public void trace(Marker marker, String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, Log4j2Logger.getMarker(marker), message, param);
    }

    public void trace(Marker marker, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, Log4j2Logger.getMarker(marker), message, params);
    }

    public void trace(Marker marker, String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, Log4j2Logger.getMarker(marker), message, cause);
    }

    public void trace(Marker marker, String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, Log4j2Logger.getMarker(marker), message, param, (Object)cause);
    }

    public void trace(Marker marker, String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, Log4j2Logger.getMarker(marker), message, (Object)params, (Object)cause);
    }

    public boolean isDebugEnabled() {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.DEBUG, null, null);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.DEBUG, Log4j2Logger.getMarker(marker), null);
    }

    public void debug(String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, null, message);
    }

    public void debug(String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, null, message, param);
    }

    public void debug(String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, null, message, params);
    }

    public void debug(String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, null, message, cause);
    }

    public void debug(String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, null, message, param, (Object)cause);
    }

    public void debug(String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, null, message, (Object)params, (Object)cause);
    }

    public void debug(Marker marker, String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, Log4j2Logger.getMarker(marker), message);
    }

    public void debug(Marker marker, String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, Log4j2Logger.getMarker(marker), message, param);
    }

    public void debug(Marker marker, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, Log4j2Logger.getMarker(marker), message, params);
    }

    public void debug(Marker marker, String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, Log4j2Logger.getMarker(marker), message, cause);
    }

    public void debug(Marker marker, String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, Log4j2Logger.getMarker(marker), message, param, (Object)cause);
    }

    public void debug(Marker marker, String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, Log4j2Logger.getMarker(marker), message, (Object)params, (Object)cause);
    }

    public boolean isInfoEnabled() {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.INFO, null, null);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.INFO, Log4j2Logger.getMarker(marker), null);
    }

    public void info(String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, null, message);
    }

    public void info(String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, null, message, param);
    }

    public void info(String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, null, message, params);
    }

    public void info(String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, null, message, cause);
    }

    public void info(String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, null, message, param, (Object)cause);
    }

    public void info(String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, null, message, (Object)params, (Object)cause);
    }

    public void info(Marker marker, String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, Log4j2Logger.getMarker(marker), message);
    }

    public void info(Marker marker, String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, Log4j2Logger.getMarker(marker), message, param);
    }

    public void info(Marker marker, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, Log4j2Logger.getMarker(marker), message, params);
    }

    public void info(Marker marker, String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, Log4j2Logger.getMarker(marker), message, cause);
    }

    public void info(Marker marker, String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, Log4j2Logger.getMarker(marker), message, param, (Object)cause);
    }

    public void info(Marker marker, String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, Log4j2Logger.getMarker(marker), message, (Object)params, (Object)cause);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.WARN, null, null);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.WARN, Log4j2Logger.getMarker(marker), null);
    }

    public void warn(String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, null, message);
    }

    public void warn(String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, null, message, param);
    }

    public void warn(String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, null, message, params);
    }

    public void warn(String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, null, message, cause);
    }

    public void warn(String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, null, message, param, (Object)cause);
    }

    public void warn(String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, null, message, (Object)params, (Object)cause);
    }

    public void warn(Marker marker, String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, Log4j2Logger.getMarker(marker), message);
    }

    public void warn(Marker marker, String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, Log4j2Logger.getMarker(marker), message, param);
    }

    public void warn(Marker marker, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, Log4j2Logger.getMarker(marker), message, params);
    }

    public void warn(Marker marker, String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, Log4j2Logger.getMarker(marker), message, cause);
    }

    public void warn(Marker marker, String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, Log4j2Logger.getMarker(marker), message, param, (Object)cause);
    }

    public void warn(Marker marker, String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, Log4j2Logger.getMarker(marker), message, (Object)params, (Object)cause);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.ERROR, null, null);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.ERROR, Log4j2Logger.getMarker(marker), null);
    }

    public void error(String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, null, message);
    }

    public void error(String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, null, message, param);
    }

    public void error(String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, null, message, params);
    }

    public void error(String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, null, message, cause);
    }

    public void error(String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, null, message, param, (Object)cause);
    }

    public void error(String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, null, message, (Object)params, (Object)cause);
    }

    public void error(Marker marker, String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, Log4j2Logger.getMarker(marker), message);
    }

    public void error(Marker marker, String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, Log4j2Logger.getMarker(marker), message, param);
    }

    public void error(Marker marker, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, Log4j2Logger.getMarker(marker), message, params);
    }

    public void error(Marker marker, String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, Log4j2Logger.getMarker(marker), message, cause);
    }

    public void error(Marker marker, String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, Log4j2Logger.getMarker(marker), message, param, (Object)cause);
    }

    public void error(Marker marker, String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, Log4j2Logger.getMarker(marker), message, (Object)params, (Object)cause);
    }

    public boolean isFatalEnabled() {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.FATAL, null, null);
    }

    public boolean isFatalEnabled(Marker marker) {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.FATAL, Log4j2Logger.getMarker(marker), null);
    }

    public void fatal(String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, null, message);
    }

    public void fatal(String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, null, message, param);
    }

    public void fatal(String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, null, message, params);
    }

    public void fatal(String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, null, message, cause);
    }

    public void fatal(String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, null, message, param, (Object)cause);
    }

    public void fatal(String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, null, message, (Object)params, (Object)cause);
    }

    public void fatal(Marker marker, String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, Log4j2Logger.getMarker(marker), message);
    }

    public void fatal(Marker marker, String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, Log4j2Logger.getMarker(marker), message, param);
    }

    public void fatal(Marker marker, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, Log4j2Logger.getMarker(marker), message, params);
    }

    public void fatal(Marker marker, String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, Log4j2Logger.getMarker(marker), message, cause);
    }

    public void fatal(Marker marker, String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, Log4j2Logger.getMarker(marker), message, param, (Object)cause);
    }

    public void fatal(Marker marker, String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, Log4j2Logger.getMarker(marker), message, (Object)params, (Object)cause);
    }

    public void log(String fqcn, Level level, Marker marker, String message, Object[] params, Throwable cause) {
        SimpleMessage msg;
        org.apache.logging.log4j.Marker log4jMarker;
        org.apache.logging.log4j.Level log4jLevel = Log4j2Logger.getLevel(level);
        if (!this.logger.isEnabled(log4jLevel, log4jMarker = Log4j2Logger.getMarker(marker), message, params)) {
            return;
        }
        if (params == null) {
            msg = new SimpleMessage(message);
        } else {
            msg = new ParameterizedMessage(message, params, cause);
            if (cause != null) {
                cause = msg.getThrowable();
            }
        }
        this.logger.logMessage(fqcn, log4jLevel, log4jMarker, (Message)msg, cause);
    }

    private static org.apache.logging.log4j.Marker getMarker(Marker marker) {
        if (marker == null) {
            return null;
        }
        if (marker instanceof Log4j2Marker) {
            return (org.apache.logging.log4j.Marker)marker;
        }
        Log4j2MarkerFactory factory = (Log4j2MarkerFactory)StaticMarkerBinder.SINGLETON.getMarkerFactory();
        return (org.apache.logging.log4j.Marker)factory.getMarker(marker);
    }

    private static org.apache.logging.log4j.Level getLevel(Level level) {
        switch (level) {
            case TRACE: {
                return org.apache.logging.log4j.Level.TRACE;
            }
            case DEBUG: {
                return org.apache.logging.log4j.Level.DEBUG;
            }
            case INFO: {
                return org.apache.logging.log4j.Level.INFO;
            }
            case WARN: {
                return org.apache.logging.log4j.Level.WARN;
            }
            case ERROR: {
                return org.apache.logging.log4j.Level.ERROR;
            }
        }
        return org.apache.logging.log4j.Level.FATAL;
    }
}

