/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.glf.log4j2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.status.StatusLogger;
import org.seppiko.glf.api.IMarkerFactory;
import org.seppiko.glf.api.Marker;
import org.seppiko.glf.log4j2.Log4j2Marker;

public class Log4j2MarkerFactory
implements IMarkerFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final ConcurrentMap<String, Marker> markerMap = new ConcurrentHashMap<String, Marker>();

    private Marker addMarkerIfAbsent(String name, org.apache.logging.log4j.Marker log4jMarker) {
        Log4j2Marker marker = new Log4j2Marker(log4jMarker);
        Marker existing = this.markerMap.putIfAbsent(name, marker);
        return existing == null ? marker : existing;
    }

    public Marker getMarker(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Marker name must not be null");
        }
        Marker marker = (Marker)this.markerMap.get(name);
        if (marker != null) {
            return marker;
        }
        org.apache.logging.log4j.Marker log4j2Marker = MarkerManager.getMarker((String)name);
        return this.addMarkerIfAbsent(name, log4j2Marker);
    }

    public Marker getMarker(Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("Marker must not be null");
        }
        Marker m = (Marker)this.markerMap.get(marker.getName());
        if (m != null) {
            return m;
        }
        return this.addMarkerIfAbsent(marker.getName(), Log4j2MarkerFactory.convertMarker(marker));
    }

    private static org.apache.logging.log4j.Marker convertMarker(Marker original) {
        if (original == null) {
            throw new IllegalArgumentException("Marker must not be null");
        }
        return Log4j2MarkerFactory.convertMarker(original, new ArrayList<Marker>());
    }

    private static org.apache.logging.log4j.Marker convertMarker(Marker original, Collection<Marker> visited) {
        org.apache.logging.log4j.Marker marker = MarkerManager.getMarker((String)original.getName());
        if (original.hasReferences()) {
            for (Marker next : original) {
                if (visited.contains(next)) {
                    LOGGER.warn("Found a cycle in Marker [{}]. Cycle will be broken.", (Object)next.getName());
                    continue;
                }
                visited.add(next);
                marker.addParents(new org.apache.logging.log4j.Marker[]{Log4j2MarkerFactory.convertMarker(next, visited)});
            }
        }
        return marker;
    }

    public boolean exists(String name) {
        return this.markerMap.containsKey(name);
    }

    public boolean detachMarker(String name) {
        return false;
    }

    public Marker getDetachedMarker(String name) {
        LOGGER.warn("Log4j2 does not support detached Markers. Returned Marker [{}] will be unchanged.", (Object)name);
        return this.getMarker(name);
    }
}

