/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.glf.impl;

import org.seppiko.glf.api.ILoggerFactory;
import org.seppiko.glf.api.LoggerFactoryBinder;
import org.seppiko.glf.log4j2.Log4j2LoggerFactory;

/**
 * Log4j 2.x logger binder
 *
 * @author Leonard Woo
 */
public class StaticLoggerBinder implements LoggerFactoryBinder {

  private static final StaticLoggerBinder SINGLETON = new StaticLoggerBinder();

  private final ILoggerFactory loggerFactory;

  public StaticLoggerBinder() {
    loggerFactory = new Log4j2LoggerFactory();
  }

  public static StaticLoggerBinder getInstance() {
    return SINGLETON;
  }

  @Override
  public ILoggerFactory getLoggerFactory() {
    return loggerFactory;
  }

  @Override
  public String getLoggerFactoryClassStr() {
    return Log4j2LoggerFactory.class.getName();
  }
}
