/*
 * Copyright 2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.glf.impl;

import org.seppiko.glf.api.IMarkerFactory;
import org.seppiko.glf.api.MarkerFactoryBinder;
import org.seppiko.glf.log4j2.Log4j2MarkerFactory;

/**
 * Log4j 2.x marker binder
 *
 * @author Leonard Woo
 */
public class StaticMarkerBinder implements MarkerFactoryBinder {

  public static final StaticMarkerBinder SINGLETON = new StaticMarkerBinder();

  private final IMarkerFactory markerFactory = new Log4j2MarkerFactory();

  @Override
  public IMarkerFactory getMarkerFactory() {
    return markerFactory;
  }

  @Override
  public String getMarkerFactoryClassStr() {
    return Log4j2MarkerFactory.class.getName();
  }
}
