/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.glf.log4j2;

import java.util.function.Supplier;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.seppiko.glf.api.Level;
import org.seppiko.glf.api.LocationLogger;
import org.seppiko.glf.api.Marker;
import org.seppiko.glf.event.LoggerEventBuilder;
import org.seppiko.glf.event.nop.NOPLoggerEventBuilder;
import org.seppiko.glf.log4j2.Log4j2EventBuilder;
import org.seppiko.glf.log4j2.Log4j2MarkerFactory;

public class Log4j2Logger
implements LocationLogger {
    public static final String FQCN = Log4j2Logger.class.getName();
    private transient ExtendedLogger logger;
    private transient Log4j2MarkerFactory markerFactory;
    private final String name;

    public Log4j2Logger(Log4j2MarkerFactory markerFactory, ExtendedLogger logger, String name) {
        this.markerFactory = markerFactory;
        this.logger = logger;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LoggerEventBuilder atLevel(Level level) {
        org.apache.logging.log4j.Level log4j2Level = Log4j2Logger.getLevel(level);
        if (this.logger.isEnabled(log4j2Level)) {
            return new Log4j2EventBuilder(this.markerFactory, this.logger.atLevel(log4j2Level));
        }
        return NOPLoggerEventBuilder.singleton();
    }

    public boolean isEnable(Level level) {
        return this.logger.isEnabled(Log4j2Logger.getLevel(level));
    }

    public boolean isEnable(Level level, Marker marker) {
        return this.logger.isEnabled(Log4j2Logger.getLevel(level), this.getMarker(marker));
    }

    public boolean isTraceEnabled() {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.TRACE, null, null);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.TRACE, this.getMarker(marker), null);
    }

    public void trace(String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, null, message);
    }

    public void trace(String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, null, message, param);
    }

    public void trace(String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, null, message, params);
    }

    public void trace(String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, null, message, cause);
    }

    public void trace(String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, null, message, param, (Object)cause);
    }

    public void trace(String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, null, message, (Object)params, (Object)cause);
    }

    public void trace(Marker marker, String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, this.getMarker(marker), message);
    }

    public void trace(Marker marker, String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, this.getMarker(marker), message, param);
    }

    public void trace(Marker marker, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, this.getMarker(marker), message, params);
    }

    public void trace(Marker marker, String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, this.getMarker(marker), message, cause);
    }

    public void trace(Marker marker, String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, this.getMarker(marker), message, param, (Object)cause);
    }

    public void trace(Marker marker, String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.TRACE, this.getMarker(marker), message, (Object)params, (Object)cause);
    }

    public LoggerEventBuilder atTrace() {
        if (this.logger.isTraceEnabled()) {
            return new Log4j2EventBuilder(this.markerFactory, this.logger.atTrace());
        }
        return NOPLoggerEventBuilder.singleton();
    }

    public boolean isDebugEnabled() {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.DEBUG, null, null);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.DEBUG, this.getMarker(marker), null);
    }

    public void debug(String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, null, message);
    }

    public void debug(String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, null, message, param);
    }

    public void debug(String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, null, message, params);
    }

    public void debug(String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, null, message, cause);
    }

    public void debug(String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, null, message, param, (Object)cause);
    }

    public void debug(String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, null, message, (Object)params, (Object)cause);
    }

    public void debug(Marker marker, String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, this.getMarker(marker), message);
    }

    public void debug(Marker marker, String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, this.getMarker(marker), message, param);
    }

    public void debug(Marker marker, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, this.getMarker(marker), message, params);
    }

    public void debug(Marker marker, String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, this.getMarker(marker), message, cause);
    }

    public void debug(Marker marker, String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, this.getMarker(marker), message, param, (Object)cause);
    }

    public void debug(Marker marker, String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.DEBUG, this.getMarker(marker), message, (Object)params, (Object)cause);
    }

    public LoggerEventBuilder atDebug() {
        if (this.logger.isDebugEnabled()) {
            return new Log4j2EventBuilder(this.markerFactory, this.logger.atDebug());
        }
        return NOPLoggerEventBuilder.singleton();
    }

    public boolean isInfoEnabled() {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.INFO, null, null);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.INFO, this.getMarker(marker), null);
    }

    public void info(String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, null, message);
    }

    public void info(String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, null, message, param);
    }

    public void info(String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, null, message, params);
    }

    public void info(String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, null, message, cause);
    }

    public void info(String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, null, message, param, (Object)cause);
    }

    public void info(String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, null, message, (Object)params, (Object)cause);
    }

    public void info(Marker marker, String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, this.getMarker(marker), message);
    }

    public void info(Marker marker, String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, this.getMarker(marker), message, param);
    }

    public void info(Marker marker, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, this.getMarker(marker), message, params);
    }

    public void info(Marker marker, String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, this.getMarker(marker), message, cause);
    }

    public void info(Marker marker, String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, this.getMarker(marker), message, param, (Object)cause);
    }

    public void info(Marker marker, String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.INFO, this.getMarker(marker), message, (Object)params, (Object)cause);
    }

    public LoggerEventBuilder atInfo() {
        if (this.logger.isInfoEnabled()) {
            return new Log4j2EventBuilder(this.markerFactory, this.logger.atInfo());
        }
        return NOPLoggerEventBuilder.singleton();
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.WARN, null, null);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.WARN, this.getMarker(marker), null);
    }

    public void warn(String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, null, message);
    }

    public void warn(String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, null, message, param);
    }

    public void warn(String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, null, message, params);
    }

    public void warn(String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, null, message, cause);
    }

    public void warn(String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, null, message, param, (Object)cause);
    }

    public void warn(String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, null, message, (Object)params, (Object)cause);
    }

    public void warn(Marker marker, String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, this.getMarker(marker), message);
    }

    public void warn(Marker marker, String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, this.getMarker(marker), message, param);
    }

    public void warn(Marker marker, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, this.getMarker(marker), message, params);
    }

    public void warn(Marker marker, String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, this.getMarker(marker), message, cause);
    }

    public void warn(Marker marker, String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, this.getMarker(marker), message, param, (Object)cause);
    }

    public void warn(Marker marker, String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.WARN, this.getMarker(marker), message, (Object)params, (Object)cause);
    }

    public LoggerEventBuilder atWarn() {
        if (this.logger.isWarnEnabled()) {
            return new Log4j2EventBuilder(this.markerFactory, this.logger.atWarn());
        }
        return NOPLoggerEventBuilder.singleton();
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.ERROR, null, null);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.ERROR, this.getMarker(marker), null);
    }

    public void error(String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, null, message);
    }

    public void error(String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, null, message, param);
    }

    public void error(String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, null, message, params);
    }

    public void error(String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, null, message, cause);
    }

    public void error(String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, null, message, param, (Object)cause);
    }

    public void error(String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, null, message, (Object)params, (Object)cause);
    }

    public void error(Marker marker, String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, this.getMarker(marker), message);
    }

    public void error(Marker marker, String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, this.getMarker(marker), message, param);
    }

    public void error(Marker marker, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, this.getMarker(marker), message, params);
    }

    public void error(Marker marker, String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, this.getMarker(marker), message, cause);
    }

    public void error(Marker marker, String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, this.getMarker(marker), message, param, (Object)cause);
    }

    public void error(Marker marker, String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.ERROR, this.getMarker(marker), message, (Object)params, (Object)cause);
    }

    public LoggerEventBuilder atError() {
        if (this.logger.isErrorEnabled()) {
            return new Log4j2EventBuilder(this.markerFactory, this.logger.atError());
        }
        return NOPLoggerEventBuilder.singleton();
    }

    public boolean isFatalEnabled() {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.FATAL, null, null);
    }

    public boolean isFatalEnabled(Marker marker) {
        return this.logger.isEnabled(org.apache.logging.log4j.Level.FATAL, this.getMarker(marker), null);
    }

    public void fatal(String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, null, message);
    }

    public void fatal(String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, null, message, param);
    }

    public void fatal(String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, null, message, params);
    }

    public void fatal(String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, null, message, cause);
    }

    public void fatal(String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, null, message, param, (Object)cause);
    }

    public void fatal(String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, null, message, (Object)params, (Object)cause);
    }

    public void fatal(Marker marker, String message) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, this.getMarker(marker), message);
    }

    public void fatal(Marker marker, String message, Object param) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, this.getMarker(marker), message, param);
    }

    public void fatal(Marker marker, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, this.getMarker(marker), message, params);
    }

    public void fatal(Marker marker, String message, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, this.getMarker(marker), message, cause);
    }

    public void fatal(Marker marker, String message, Object param, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, this.getMarker(marker), message, param, (Object)cause);
    }

    public void fatal(Marker marker, String message, Object[] params, Throwable cause) {
        this.logger.logIfEnabled(FQCN, org.apache.logging.log4j.Level.FATAL, this.getMarker(marker), message, (Object)params, (Object)cause);
    }

    public LoggerEventBuilder atFatal() {
        if (this.logger.isFatalEnabled()) {
            return new Log4j2EventBuilder(this.markerFactory, this.logger.atFatal());
        }
        return NOPLoggerEventBuilder.singleton();
    }

    public void log(String fqcn, Level level, Marker marker, String message, Object[] params, Throwable cause) {
        SimpleMessage msg;
        org.apache.logging.log4j.Marker log4jMarker;
        org.apache.logging.log4j.Level log4jLevel = Log4j2Logger.getLevel(level);
        if (!this.logger.isEnabled(log4jLevel, log4jMarker = this.getMarker(marker), message, params)) {
            return;
        }
        if (params == null) {
            msg = new SimpleMessage(message);
        } else {
            msg = new ParameterizedMessage(message, params, cause);
            if (cause != null) {
                cause = msg.getThrowable();
            }
        }
        this.logger.logMessage(fqcn, log4jLevel, log4jMarker, (Message)msg, cause);
    }

    public void log(String fqcn, Level level, Marker marker, String message, Supplier<?>[] paramSuppliers, Throwable cause) {
    }

    private org.apache.logging.log4j.Marker getMarker(Marker marker) {
        return this.markerFactory.getLog4j2Marker(marker);
    }

    public boolean isEnabledForLevel(Level level) {
        return this.logger.isEnabled(Log4j2Logger.getLevel(level));
    }

    private static org.apache.logging.log4j.Level getLevel(Level level) {
        return switch (level) {
            case Level.TRACE -> org.apache.logging.log4j.Level.TRACE;
            case Level.DEBUG -> org.apache.logging.log4j.Level.DEBUG;
            case Level.INFO -> org.apache.logging.log4j.Level.INFO;
            case Level.WARN -> org.apache.logging.log4j.Level.WARN;
            case Level.ERROR -> org.apache.logging.log4j.Level.ERROR;
            default -> org.apache.logging.log4j.Level.FATAL;
        };
    }
}

