/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.glf.log4j2;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.BridgeAware;
import org.apache.logging.log4j.LogBuilder;
import org.seppiko.glf.api.Marker;
import org.seppiko.glf.event.LoggerEventBuilder;
import org.seppiko.glf.log4j2.Log4j2MarkerFactory;

public class Log4j2EventBuilder
implements LoggerEventBuilder {
    private static final String FQCN = Log4j2EventBuilder.class.getName();
    private final Log4j2MarkerFactory markerFactory;
    private final LogBuilder logBuilder;
    private final List<Object> arguments = new ArrayList<Object>();
    private String message = null;

    public Log4j2EventBuilder(Log4j2MarkerFactory markerFactory, LogBuilder logBuilder) {
        this.markerFactory = markerFactory;
        this.logBuilder = logBuilder;
        if (logBuilder instanceof BridgeAware) {
            ((BridgeAware)logBuilder).setEntryPoint(FQCN);
        }
    }

    public LoggerEventBuilder marker(Marker marker) {
        this.logBuilder.withMarker(this.markerFactory.convertMarker(marker));
        return this;
    }

    public LoggerEventBuilder message(String message) {
        this.message = message;
        return this;
    }

    public LoggerEventBuilder withCause(Throwable cause) {
        this.logBuilder.withThrowable(cause);
        return this;
    }

    public LoggerEventBuilder addParam(Supplier<?> paramSupplier) {
        this.arguments.add(paramSupplier.get());
        return this;
    }

    public LoggerEventBuilder addParam(Object paramObject) {
        this.arguments.add(paramObject);
        return this;
    }

    public void log() {
        this.logBuilder.log(this.message, this.arguments.toArray());
    }
}

