/*
 * Copyright 2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.glf.scl;

import java.util.ArrayList;
import java.util.function.Supplier;
import org.seppiko.commons.logging.LoggingBuilder;

/**
 * Logging builder over GLF
 *
 * @author Leonard Woo
 */
public class GLFLoggingBuilder implements LoggingBuilder {

  private final GLFLogging logging;
  private final int level;
  private CharSequence message;
  private Throwable cause;
  private ArrayList<Object> params = new ArrayList<>();

  GLFLoggingBuilder(GLFLogging logging, int level) {
    this.logging = logging;
    this.level = level;
  }

  /** {@inheritDoc} */
  @Override
  public LoggingBuilder message(CharSequence message) {
    this.message = message;
    return this;
  }

  /** {@inheritDoc} */
  @Override
  public LoggingBuilder withCause(Throwable cause) {
    this.cause = cause;
    return this;
  }

  /** {@inheritDoc} */
  @Override
  public LoggingBuilder param(Supplier<?> paramSupplier) {
    params.add(paramSupplier.get());
    return this;
  }

  /** {@inheritDoc} */
  @Override
  public void log() {
    Supplier<?>[] suppliers = params.toArray(Supplier[]::new);
    logging.log(level, message, cause, suppliers);
  }
}
