/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.glf.osgi;

import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.log.LogService;
import org.seppiko.glf.api.Logger;
import org.seppiko.glf.api.LoggerFactory;

public class LogServiceImpl
implements LogService {
    private final Logger delegate;

    public LogServiceImpl(Bundle bundle) {
        String name = bundle.getSymbolicName();
        Version version = bundle.getVersion();
        if (version == null) {
            version = Version.emptyVersion;
        }
        this.delegate = LoggerFactory.getLogger((String)(name + "." + version));
    }

    public void log(int level, String message) {
        switch (level) {
            case 4: {
                this.delegate.debug(message);
                break;
            }
            case 3: {
                this.delegate.info(message);
                break;
            }
            case 2: {
                this.delegate.warn(message);
                break;
            }
            case 1: {
                this.delegate.error(message);
                break;
            }
            default: {
                this.delegate.error("OSGi called an invalid level.");
            }
        }
    }

    public void log(int level, String message, Throwable cause) {
        switch (level) {
            case 4: {
                this.delegate.debug(message, cause);
                break;
            }
            case 1: {
                this.delegate.error(message, cause);
                break;
            }
            case 3: {
                this.delegate.info(message, cause);
                break;
            }
            case 2: {
                this.delegate.warn(message, cause);
                break;
            }
            default: {
                this.delegate.error("OSGi called an invalid level.");
            }
        }
    }

    public void log(ServiceReference sr, int level, String message) {
        switch (level) {
            case 4: {
                if (!this.delegate.isDebugEnabled()) break;
                this.delegate.debug(this.createMessage(sr, message));
                break;
            }
            case 1: {
                if (!this.delegate.isErrorEnabled()) break;
                this.delegate.error(this.createMessage(sr, message));
                break;
            }
            case 3: {
                if (!this.delegate.isInfoEnabled()) break;
                this.delegate.info(this.createMessage(sr, message));
                break;
            }
            case 2: {
                if (!this.delegate.isWarnEnabled()) break;
                this.delegate.warn(this.createMessage(sr, message));
                break;
            }
            default: {
                this.delegate.error("OSGi called an invalid level.");
            }
        }
    }

    public void log(ServiceReference sr, int level, String message, Throwable cause) {
        switch (level) {
            case 4: {
                if (!this.delegate.isDebugEnabled()) break;
                this.delegate.debug(this.createMessage(sr, message), cause);
                break;
            }
            case 1: {
                if (!this.delegate.isErrorEnabled()) break;
                this.delegate.error(this.createMessage(sr, message), cause);
                break;
            }
            case 3: {
                if (!this.delegate.isInfoEnabled()) break;
                this.delegate.info(this.createMessage(sr, message), cause);
                break;
            }
            case 2: {
                if (!this.delegate.isWarnEnabled()) break;
                this.delegate.warn(this.createMessage(sr, message), cause);
                break;
            }
            default: {
                this.delegate.error("OSGi called an invalid level.");
            }
        }
    }

    private String createMessage(ServiceReference sr, String message) {
        StringBuilder output = new StringBuilder();
        if (sr != null) {
            output.append('[').append(sr.toString()).append(']');
        } else {
            output.append("[UNKNOWN]");
        }
        output.append(message);
        return output.toString();
    }
}

