/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.plugins.project;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="project-model", defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class ProjectModel
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true, property="properties.outputFile")
    private File outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project == null) {
            throw new MojoFailureException("Can not get maven model.");
        }
        Properties prop = new Properties();
        prop.setProperty("group-id", this.project.getGroupId());
        prop.setProperty("artifact-id", this.project.getArtifactId());
        prop.setProperty("version", this.project.getVersion());
        this.writeProperties(prop);
    }

    protected void writeProperties(Properties properties) throws MojoExecutionException {
        String comments = "Generator by " + this.project.getName() + " " + this.project.getVersion();
        try (PrintWriter pw = new PrintWriter(this.outputFile, StandardCharsets.ISO_8859_1);
             StringWriter sw = new StringWriter();){
            properties.store(sw, comments);
            comments = "#" + comments;
            ArrayList<String> lines = new ArrayList<String>(properties.size());
            try (BufferedReader r = new BufferedReader(new StringReader(sw.toString()));){
                String line;
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#") && !line.equals(comments)) continue;
                    lines.add(line);
                }
            }
            Collections.sort(lines);
            for (String l : lines) {
                pw.println(l);
            }
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)("Could not create FileOutputStream: " + this.outputFile));
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error writing properties: " + this.outputFile));
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

