/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

class BitBuffer {
    private byte[] buffer;
    private int length;
    private final int inclements;

    public BitBuffer() {
        this.inclements = 32;
        this.buffer = new byte[this.inclements];
        this.length = 0;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getLengthInBits() {
        return this.length;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.getLengthInBits(); ++i) {
            buffer.append(this.get(i) ? (char)'1' : '0');
        }
        return buffer.toString();
    }

    private boolean get(int index) {
        return (this.buffer[index / 8] >>> 7 - index % 8 & 1) == 1;
    }

    public void put(int num, int length) {
        for (int i = 0; i < length; ++i) {
            this.put((num >>> length - i - 1 & 1) == 1);
        }
    }

    public void put(boolean bit) {
        if (this.length == this.buffer.length * 8) {
            byte[] newBuffer = new byte[this.buffer.length + this.inclements];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        if (bit) {
            int n = this.length / 8;
            this.buffer[n] = (byte)(this.buffer[n] | (byte)(128 >>> this.length % 8));
        }
        ++this.length;
    }
}

