/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class GIFImage {
    private final int width;
    private final int height;
    private final int[] data;

    public GIFImage(int width, int height) {
        this.width = width;
        this.height = height;
        this.data = new int[width * height];
    }

    private static void write(OutputStream out, int i) throws IOException {
        out.write(i & 0xFF);
        out.write(i >>> 8 & 0xFF);
    }

    public void setPixel(int x, int y, int pixel) {
        if (x < 0 || this.width <= x || y < 0 || this.height <= y) {
            throw new IllegalArgumentException();
        }
        this.data[y * this.width + x] = pixel;
    }

    public int getPixel(int x, int y) {
        if (x < 0 || this.width <= x) {
            throw new IllegalArgumentException();
        }
        if (y < 0 || this.height <= y) {
            throw new IllegalArgumentException();
        }
        return this.data[y * this.width + x];
    }

    public void write(OutputStream out) throws IOException {
        out.write("GIF87a".getBytes(StandardCharsets.ISO_8859_1));
        GIFImage.write(out, this.width);
        GIFImage.write(out, this.height);
        out.write(128);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(255);
        out.write(255);
        out.write(255);
        out.write(44);
        GIFImage.write(out, 0);
        GIFImage.write(out, 0);
        GIFImage.write(out, this.width);
        GIFImage.write(out, this.height);
        out.write(0);
        int lzwMinCodeSize = 2;
        byte[] raster = this.getLZWRaster(lzwMinCodeSize);
        out.write(lzwMinCodeSize);
        int offset = 0;
        while (raster.length - offset > 255) {
            out.write(255);
            out.write(raster, offset, 255);
            offset += 255;
        }
        out.write(raster.length - offset);
        out.write(raster, offset, raster.length - offset);
        out.write(0);
        out.write(59);
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getLZWRaster(int lzwMinCodeSize) throws IOException {
        int clearCode = 1 << lzwMinCodeSize;
        int endCode = (1 << lzwMinCodeSize) + 1;
        int bitLength = lzwMinCodeSize + 1;
        LZWTable table = new LZWTable();
        for (int i = 0; i < clearCode; ++i) {
            table.add(String.valueOf((char)i));
        }
        table.add(String.valueOf((char)clearCode));
        table.add(String.valueOf((char)endCode));
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try (BitOutputStream bitOut = new BitOutputStream(byteOut);){
            bitOut.write(clearCode, bitLength);
            int dataIndex = 0;
            Object s = String.valueOf((char)this.data[dataIndex++]);
            while (dataIndex < this.data.length) {
                char c;
                if (table.contains((String)s + (c = (char)this.data[dataIndex++]))) {
                    s = (String)s + c;
                    continue;
                }
                bitOut.write(table.indexOf((String)s), bitLength);
                if (table.size() < 4095) {
                    if (table.size() == 1 << bitLength) {
                        ++bitLength;
                    }
                    table.add((String)s + c);
                }
                s = String.valueOf(c);
            }
            bitOut.write(table.indexOf((String)s), bitLength);
            bitOut.write(endCode, bitLength);
        }
        return byteOut.toByteArray();
    }

    private static class LZWTable {
        private final Map<String, Integer> map = new HashMap<String, Integer>();

        public void add(String key) {
            if (this.contains(key)) {
                throw new IllegalArgumentException("dup key:" + key);
            }
            this.map.put(key, this.map.size());
        }

        public int size() {
            return this.map.size();
        }

        public int indexOf(String key) {
            return this.map.get(key);
        }

        public boolean contains(String key) {
            return this.map.containsKey(key);
        }
    }

    private static class BitOutputStream {
        private final OutputStream out;
        private int bitLength;
        private int bitBuffer;

        public BitOutputStream(OutputStream out) {
            this.out = out;
            this.bitLength = 0;
        }

        public void write(int data, int length) throws IOException {
            if (data >>> length != 0) {
                throw new IOException("length over");
            }
            while (this.bitLength + length >= 8) {
                this.out.write(0xFF & (data << this.bitLength | this.bitBuffer));
                length -= 8 - this.bitLength;
                data >>>= 8 - this.bitLength;
                this.bitBuffer = 0;
                this.bitLength = 0;
            }
            this.bitBuffer = data << this.bitLength | this.bitBuffer;
            this.bitLength += length;
        }

        public void flush() throws IOException {
            if (this.bitLength > 0) {
                this.out.write(this.bitBuffer);
            }
            this.out.flush();
        }

        public void close() throws IOException {
            this.flush();
            this.out.close();
        }
    }
}

