/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

import com.d_project.qrcode.QRMath;

class Polynomial {
    private final int[] num;

    public Polynomial(int[] num) {
        this(num, 0);
    }

    public Polynomial(int[] num, int shift) {
        int offset;
        for (offset = 0; offset < num.length && num[offset] == 0; ++offset) {
        }
        this.num = new int[num.length - offset + shift];
        System.arraycopy(num, offset, this.num, 0, num.length - offset);
    }

    public int get(int index) {
        return this.num[index];
    }

    public int getLength() {
        return this.num.length;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.getLength(); ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.get(i));
        }
        return buffer.toString();
    }

    public String toLogString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.getLength(); ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(QRMath.glog(this.get(i)));
        }
        return buffer.toString();
    }

    public Polynomial multiply(Polynomial e) {
        int[] num = new int[this.getLength() + e.getLength() - 1];
        for (int i = 0; i < this.getLength(); ++i) {
            for (int j = 0; j < e.getLength(); ++j) {
                int n = i + j;
                num[n] = num[n] ^ QRMath.gexp(QRMath.glog(this.get(i)) + QRMath.glog(e.get(j)));
            }
        }
        return new Polynomial(num);
    }

    public Polynomial mod(Polynomial e) {
        int i;
        if (this.getLength() - e.getLength() < 0) {
            return this;
        }
        int ratio = QRMath.glog(this.get(0)) - QRMath.glog(e.get(0));
        int[] num = new int[this.getLength()];
        for (i = 0; i < this.getLength(); ++i) {
            num[i] = this.get(i);
        }
        for (i = 0; i < e.getLength(); ++i) {
            int n = i;
            num[n] = num[n] ^ QRMath.gexp(QRMath.glog(e.get(i)) + ratio);
        }
        return new Polynomial(num).mod(e);
    }
}

