/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

import com.d_project.qrcode.BitBuffer;
import com.d_project.qrcode.QRData;

class QRAlphaNum
extends QRData {
    public QRAlphaNum(String data) {
        super(2, data);
    }

    private static int getCode(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'Z') {
            return c - 65 + 10;
        }
        return switch (c) {
            case ' ' -> 36;
            case '$' -> 37;
            case '%' -> 38;
            case '*' -> 39;
            case '+' -> 40;
            case '-' -> 41;
            case '.' -> 42;
            case '/' -> 43;
            case ':' -> 44;
            default -> throw new IllegalArgumentException("illegal char :" + c);
        };
    }

    @Override
    public void write(BitBuffer buffer) {
        char[] c = this.getData().toCharArray();
        int i = 0;
        while (i + 1 < c.length) {
            buffer.put(QRAlphaNum.getCode(c[i]) * 45 + QRAlphaNum.getCode(c[i + 1]), 11);
            i += 2;
        }
        if (i < c.length) {
            buffer.put(QRAlphaNum.getCode(c[i]), 6);
        }
    }

    @Override
    public int getLength() {
        return this.getData().length();
    }
}

