/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

import com.d_project.qrcode.BitBuffer;

abstract class QRData {
    private final int mode;
    private final String data;

    protected QRData(int mode, String data) {
        this.mode = mode;
        this.data = data;
    }

    public int getMode() {
        return this.mode;
    }

    public String getData() {
        return this.data;
    }

    public abstract int getLength();

    public abstract void write(BitBuffer var1);

    public int getLengthInBits(int type) {
        if (1 <= type && type < 10) {
            return switch (this.mode) {
                case 1 -> 10;
                case 2 -> 9;
                case 4, 8 -> 8;
                default -> throw new IllegalArgumentException("mode: " + this.mode);
            };
        }
        if (type < 27) {
            return switch (this.mode) {
                case 1 -> 12;
                case 2 -> 11;
                case 4 -> 16;
                case 8 -> 10;
                default -> throw new IllegalArgumentException("mode: " + this.mode);
            };
        }
        if (type < 41) {
            return switch (this.mode) {
                case 1 -> 14;
                case 2 -> 13;
                case 4 -> 16;
                case 8 -> 12;
                default -> throw new IllegalArgumentException("mode: " + this.mode);
            };
        }
        throw new IllegalArgumentException("type: " + type);
    }
}

