/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.snowflake;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class IdWorker {
    private final long unusedBits = 1L;
    private final long timestampBits = 41L;
    private final long datacenterIdBits = 5L;
    private final long workerIdBits = 5L;
    private final long sequenceBits = 12L;
    private final long maxDatacenterId = 31L;
    private final long maxWorkerId = 31L;
    private final long maxSequence = 4095L;
    private final long timestampShift = 22L;
    private final long datacenterIdShift = 17L;
    private final long workerIdShift = 12L;
    private long epochMilli;
    private long datacenterId = -1L;
    private long workerId = -1L;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static IdWorker instance;
    private final Lock lock = new ReentrantLock();
    private final AtomicLong waitCount = new AtomicLong(0L);
    private final ZoneId utc = ZoneId.of("UTC");

    public static synchronized IdWorker getInstance(long offsetTimestamp) {
        if (instance == null) {
            instance = new IdWorker(offsetTimestamp);
        }
        return instance;
    }

    private IdWorker(long offsetTimestamp) {
        this.epochMilli = offsetTimestamp;
    }

    public void initWorker(long datacenterId, long workerId) {
        this.setDatacenterId(datacenterId);
        this.setWorkerId(workerId);
    }

    public void setDatacenterId(long datacenterId) {
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter id can't be greater than %d or less than 0", 31L));
        }
        this.datacenterId = datacenterId;
    }

    public void setWorkerId(long workerId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextId() {
        try {
            long snowflake;
            this.lock.lock();
            if (this.datacenterId < 0L || this.workerId < 0L) {
                throw new IllegalArgumentException("datacenter Id and worker Id MUST BE initialization.");
            }
            long currTimestamp = this.now();
            if (currTimestamp < this.lastTimestamp) {
                throw new IllegalStateException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - currTimestamp));
            }
            if (currTimestamp == this.lastTimestamp) {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    currTimestamp = this.waitNextMillis(currTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = currTimestamp;
            long l = snowflake = currTimestamp - this.epochMilli << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getWaitCount() {
        return this.waitCount.get();
    }

    public long getEpochMilli() {
        return this.epochMilli;
    }

    public long getSequence() {
        return this.sequence;
    }

    private long waitNextMillis(long currTimestamp) {
        this.waitCount.incrementAndGet();
        while (currTimestamp <= this.lastTimestamp) {
            currTimestamp = this.now();
        }
        return currTimestamp;
    }

    private long now() {
        return Instant.now(Clock.system(this.utc)).toEpochMilli();
    }

    private String datetimeFormat(long timestamp) {
        ZonedDateTime datetime = Instant.ofEpochMilli(timestamp).atZone(this.utc);
        return datetime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public String formatId(long id) {
        long timestamp = ((id & this.diode(1L, 41L)) >> 22) + this.epochMilli;
        long datacenterId = (id & this.diode(42L, 5L)) >> 17;
        long workerId = (id & this.diode(47L, 5L)) >> 12;
        long sequence = id & this.diode(52L, 12L);
        String tmf = this.datetimeFormat(timestamp);
        return String.format("%s, #%d, @(%d,%d)", tmf, sequence, datacenterId, workerId);
    }

    private long diode(long offset, long length) {
        int lb = (int)(64L - offset);
        int rb = (int)(64L - (offset + length));
        return -1L << lb ^ -1L << rb;
    }

    public String toString() {
        return "Snowflake [timestampBits=41, datacenterIdBits=5, workerIdBits=5, sequenceBits=12, epochMilli=" + this.epochMilli + ", datacenterId=" + this.datacenterId + ", workerId=" + this.workerId + "]";
    }
}

