/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordSetBuilder;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.Interval;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.seqdoop.hadoop_bam.BAMInputFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;

public class TestBAMInputFormat {
    private String input;
    private TaskAttemptContext taskAttemptContext;
    private JobContext jobContext;

    @Before
    public void setup() throws Exception {
        this.input = this.writeNameSortedBamFile().getAbsolutePath();
    }

    private File writeNameSortedBamFile() throws IOException {
        SAMRecordSetBuilder samRecordSetBuilder = new SAMRecordSetBuilder(true, SAMFileHeader.SortOrder.queryname);
        for (int i = 0; i < 1000; ++i) {
            int chr = 20;
            int start1 = (i + 1) * 1000;
            int start2 = start1 + 100;
            samRecordSetBuilder.addPair(String.format("test-read-%03d", i), chr, start1, start2);
        }
        File bamFile = File.createTempFile("test", ".bam");
        bamFile.deleteOnExit();
        SAMFileHeader samHeader = samRecordSetBuilder.getHeader();
        SAMFileWriter bamWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(samHeader, true, bamFile);
        for (SAMRecord rec : samRecordSetBuilder.getRecords()) {
            bamWriter.addAlignment(rec);
        }
        bamWriter.close();
        SamReader samReader = SamReaderFactory.makeDefault().enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS}).open(bamFile);
        BAMIndexer.createIndex((SamReader)samReader, (File)new File(bamFile.getAbsolutePath() + ".bai"));
        return bamFile;
    }

    private void completeSetup(boolean keepPairedReadsTogether, List<Interval> intervals) {
        Configuration conf = new Configuration();
        conf.set("mapred.input.dir", "file://" + this.input);
        conf.setBoolean("hadoopbam.bam.keep-paired-reads-together", keepPairedReadsTogether);
        if (intervals != null) {
            BAMInputFormat.setIntervals((Configuration)conf, intervals);
        }
        this.taskAttemptContext = ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)((TaskAttemptID)Mockito.mock(TaskAttemptID.class)));
        this.jobContext = ContextUtil.newJobContext((Configuration)conf, (JobID)this.taskAttemptContext.getJobID());
    }

    @Test
    public void testDontKeepPairedReadsTogether() throws Exception {
        this.completeSetup(false, null);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)2L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        List<SAMRecord> split1Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(1));
        Assert.assertEquals((long)1629L, (long)split0Records.size());
        Assert.assertEquals((long)371L, (long)split1Records.size());
        SAMRecord lastRecordOfSplit0 = split0Records.get(split0Records.size() - 1);
        SAMRecord firstRecordOfSplit1 = split1Records.get(0);
        Assert.assertEquals((Object)lastRecordOfSplit0.getReadName(), (Object)firstRecordOfSplit1.getReadName());
        Assert.assertTrue((boolean)lastRecordOfSplit0.getFirstOfPairFlag());
        Assert.assertTrue((boolean)firstRecordOfSplit1.getSecondOfPairFlag());
    }

    @Test
    public void testKeepPairedReadsTogether() throws Exception {
        this.completeSetup(true, null);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)2L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        List<SAMRecord> split1Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(1));
        Assert.assertEquals((long)1630L, (long)split0Records.size());
        Assert.assertEquals((long)370L, (long)split1Records.size());
        SAMRecord lastRecordOfSplit0 = split0Records.get(split0Records.size() - 1);
        SAMRecord firstRecordOfSplit1 = split1Records.get(0);
        Assert.assertNotEquals((Object)lastRecordOfSplit0.getReadName(), (Object)firstRecordOfSplit1.getReadName());
    }

    @Test
    public void testIntervals() throws Exception {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        intervals.add(new Interval("chr21", 5000, 9999));
        intervals.add(new Interval("chr21", 20000, 22999));
        this.completeSetup(false, intervals);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)1L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        Assert.assertEquals((long)16L, (long)split0Records.size());
    }

    @Test
    public void testIntervalCoveringWholeChromosome() throws Exception {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        intervals.add(new Interval("chr21", 1, 1000135));
        this.completeSetup(false, intervals);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)2L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        List<SAMRecord> split1Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(1));
        Assert.assertEquals((long)1629L, (long)split0Records.size());
        Assert.assertEquals((long)371L, (long)split1Records.size());
    }

    private List<SAMRecord> getSAMRecordsFromSplit(BAMInputFormat inputFormat, InputSplit split) throws Exception {
        RecordReader reader = inputFormat.createRecordReader(split, this.taskAttemptContext);
        reader.initialize(split, this.taskAttemptContext);
        ArrayList<SAMRecord> records = new ArrayList<SAMRecord>();
        while (reader.nextKeyValue()) {
            SAMRecord r = ((SAMRecordWritable)reader.getCurrentValue()).get();
            records.add(r);
        }
        return records;
    }
}

