/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.seqdoop.hadoop_bam.BAMInputFormat;
import org.seqdoop.hadoop_bam.KeyIgnoringBAMOutputFormat;
import org.seqdoop.hadoop_bam.SAMFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;
import org.seqdoop.hadoop_bam.util.SAMOutputPreparer;

public class TestBAMOutputFormat {
    private String testBAMFileName;
    private int expectedRecordCount;
    private SAMFileHeader samFileHeader;
    private TaskAttemptContext taskAttemptContext;
    private static Configuration conf;

    @Before
    public void setup() throws Exception {
        conf = new Configuration();
        this.testBAMFileName = ClassLoader.getSystemClassLoader().getResource("test.bam").getFile();
        conf.set("mapred.input.dir", "file://" + this.testBAMFileName);
        this.expectedRecordCount = this.getBAMRecordCount(this.testBAMFileName);
        this.samFileHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(this.testBAMFileName), (Configuration)conf);
        this.taskAttemptContext = ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)((TaskAttemptID)Mockito.mock(TaskAttemptID.class)));
    }

    @Test
    public void testBAMRecordWriterNoHeader() throws Exception {
        File outFile = File.createTempFile("testBAMWriter", ".bam");
        outFile.deleteOnExit();
        Path outPath = new Path(outFile.toURI());
        BAMTestNoHeaderOutputFormat bamOut = new BAMTestNoHeaderOutputFormat();
        conf.set("TestBAM.header", this.testBAMFileName);
        bamOut.setWriteHeader(false);
        RecordWriter<NullWritable, SAMRecordWritable> rw = bamOut.getRecordWriter(this.taskAttemptContext, outPath);
        SamReader samReader = SamReaderFactory.makeDefault().open(new File(this.testBAMFileName));
        for (SAMRecord r : samReader) {
            SAMRecordWritable samRW = new SAMRecordWritable();
            samRW.set(r);
            rw.write(null, (Object)samRW);
        }
        samReader.close();
        rw.close(this.taskAttemptContext);
        int actualCount = this.verifyBAMBlocks(new File(outFile.getAbsolutePath()), this.samFileHeader, true);
        Assert.assertEquals((long)this.expectedRecordCount, (long)actualCount);
    }

    @Test
    public void testBAMRecordWriterWithHeader() throws Exception {
        File outFile = File.createTempFile("testBAMWriter", ".bam");
        outFile.deleteOnExit();
        Path outPath = new Path(outFile.toURI());
        BAMTestWithHeaderOutputFormat bamOut = new BAMTestWithHeaderOutputFormat();
        conf.set("TestBAM.header", this.testBAMFileName);
        bamOut.setWriteHeader(false);
        RecordWriter<NullWritable, SAMRecordWritable> rw = bamOut.getRecordWriter(this.taskAttemptContext, outPath);
        SamReader samReader = SamReaderFactory.makeDefault().open(new File(this.testBAMFileName));
        for (SAMRecord r : samReader) {
            SAMRecordWritable samRW = new SAMRecordWritable();
            samRW.set(r);
            rw.write(null, (Object)samRW);
        }
        samReader.close();
        rw.close(this.taskAttemptContext);
        int actualCount = this.verifyBAMBlocks(new File(outFile.getAbsolutePath()), this.samFileHeader, false);
        Assert.assertEquals((long)this.expectedRecordCount, (long)actualCount);
    }

    @Test
    public void testBAMOutput() throws Exception {
        Path outputPath = this.doMapReduce(this.testBAMFileName);
        File blockStreamFile = new File(new File(outputPath.toUri()), "part-m-00000");
        int actualCount = this.verifyBAMBlocks(blockStreamFile, this.samFileHeader, true);
        Assert.assertEquals((long)this.expectedRecordCount, (long)actualCount);
    }

    @Test
    public void testBAMRoundTrip() throws Exception {
        Path outputPath = this.doMapReduce(this.testBAMFileName);
        File blockStreamFile = new File(new File(outputPath.toUri()), "part-m-00000");
        ByteArrayInputStream bamStream = this.mergeBAMBlockStream(blockStreamFile, this.samFileHeader, true);
        File outFile = File.createTempFile("testBAMWriter", ".bam");
        outFile.deleteOnExit();
        Files.copy(bamStream, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        outputPath = this.doMapReduce(outFile.getAbsolutePath());
        blockStreamFile = new File(new File(outputPath.toUri()), "part-m-00000");
        int actualCount = this.verifyBAMBlocks(blockStreamFile, this.samFileHeader, true);
        Assert.assertEquals((long)this.expectedRecordCount, (long)actualCount);
    }

    private int getBAMRecordCount(String bamFileName) throws IOException {
        SamReader bamReader = SamReaderFactory.makeDefault().open(SamInputResource.of((String)bamFileName));
        SAMRecordIterator it = bamReader.iterator();
        int recCount = 0;
        while (it.hasNext()) {
            it.next();
            ++recCount;
        }
        bamReader.close();
        return recCount;
    }

    private Path doMapReduce(String inputFile) throws Exception {
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        Path inputPath = new Path(inputFile);
        Path outputPath = fileSystem.makeQualified(new Path("target/out"));
        fileSystem.delete(outputPath, true);
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputPath});
        conf.set("TestBAM.header", inputFile);
        job.setInputFormatClass(BAMInputFormat.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(SAMRecordWritable.class);
        job.setOutputFormatClass(BAMTestNoHeaderOutputFormat.class);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(SAMRecordWritable.class);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        boolean success = job.waitForCompletion(true);
        Assert.assertTrue((boolean)success);
        return outputPath;
    }

    private int verifyBAMBlocks(File blockStreamFile, SAMFileHeader header, boolean writeHeader) throws IOException {
        ByteArrayInputStream mergedStream = this.mergeBAMBlockStream(blockStreamFile, header, writeHeader);
        SamReader resultBAMReader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)mergedStream));
        SAMRecordIterator it = resultBAMReader.iterator();
        int actualCount = 0;
        while (it.hasNext()) {
            it.next();
            ++actualCount;
        }
        return actualCount;
    }

    private ByteArrayInputStream mergeBAMBlockStream(File blockStreamFile, SAMFileHeader header, boolean writeHeader) throws IOException {
        ByteArrayOutputStream bamOutputStream = new ByteArrayOutputStream();
        if (writeHeader) {
            new SAMOutputPreparer().prepareForRecords((OutputStream)bamOutputStream, SAMFormat.BAM, header);
        }
        ByteArrayOutputStream blockOutputStream = new ByteArrayOutputStream();
        Files.copy(blockStreamFile.toPath(), blockOutputStream);
        blockOutputStream.writeTo(bamOutputStream);
        bamOutputStream.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
        bamOutputStream.close();
        return new ByteArrayInputStream(bamOutputStream.toByteArray());
    }

    static class BAMTestNoHeaderOutputFormat
    extends KeyIgnoringBAMOutputFormat<NullWritable> {
        public static final String READ_HEADER_FROM_FILE = "TestBAM.header";

        BAMTestNoHeaderOutputFormat() {
        }

        public RecordWriter<NullWritable, SAMRecordWritable> getRecordWriter(TaskAttemptContext ctx, Path outputPath) throws IOException {
            this.readSAMHeaderFrom(new Path(conf.get(READ_HEADER_FROM_FILE)), conf);
            this.setWriteHeader(false);
            return super.getRecordWriter(ctx, outputPath);
        }
    }

    static class BAMTestWithHeaderOutputFormat
    extends KeyIgnoringBAMOutputFormat<NullWritable> {
        public static final String READ_HEADER_FROM_FILE = "TestBAM.header";

        BAMTestWithHeaderOutputFormat() {
        }

        public RecordWriter<NullWritable, SAMRecordWritable> getRecordWriter(TaskAttemptContext ctx, Path outputPath) throws IOException {
            this.readSAMHeaderFrom(new Path(conf.get(READ_HEADER_FROM_FILE)), conf);
            this.setWriteHeader(true);
            return super.getRecordWriter(ctx, outputPath);
        }
    }
}

