/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.seqdoop.hadoop_bam.CRAMInputFormat;

public class TestCRAMInputFormatOnHDFS {
    private String input;
    private String reference;
    private TaskAttemptContext taskAttemptContext;
    private JobContext jobContext;
    private static MiniDFSCluster cluster;
    private static URI clusterUri;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        cluster = TestCRAMInputFormatOnHDFS.startMini(TestCRAMInputFormatOnHDFS.class.getName());
        clusterUri = TestCRAMInputFormatOnHDFS.formalizeClusterURI(cluster.getFileSystem().getUri());
    }

    @AfterClass
    public static void teardownClass() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setup() throws Exception {
        Configuration conf = new Configuration();
        this.input = ClassLoader.getSystemClassLoader().getResource("test.cram").getFile();
        this.reference = ClassLoader.getSystemClassLoader().getResource("auxf.fa").toURI().toString();
        String referenceIndex = ClassLoader.getSystemClassLoader().getResource("auxf.fa.fai").toURI().toString();
        conf.set("mapred.input.dir", "file://" + this.input);
        URI hdfsRef = clusterUri.resolve("/tmp/auxf.fa");
        URI hdfsRefIndex = clusterUri.resolve("/tmp/auxf.fa.fai");
        Files.copy(Paths.get(URI.create(this.reference)), Paths.get(hdfsRef), new CopyOption[0]);
        Files.copy(Paths.get(URI.create(referenceIndex)), Paths.get(hdfsRefIndex), new CopyOption[0]);
        conf.set("hadoopbam.cram.reference-source-path", hdfsRef.toString());
        this.taskAttemptContext = ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)((TaskAttemptID)Mockito.mock(TaskAttemptID.class)));
        this.jobContext = ContextUtil.newJobContext((Configuration)conf, (JobID)this.taskAttemptContext.getJobID());
    }

    private static MiniDFSCluster startMini(String testName) throws IOException {
        File baseDir = new File("./target/hdfs/" + testName).getAbsoluteFile();
        FileUtil.fullyDelete((File)baseDir);
        Configuration conf = new Configuration();
        conf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
        MiniDFSCluster hdfsCluster = builder.clusterId(testName).build();
        hdfsCluster.waitActive();
        return hdfsCluster;
    }

    protected static URI formalizeClusterURI(URI clusterUri) throws URISyntaxException {
        if (clusterUri.getPath() == null) {
            return new URI(clusterUri.getScheme(), null, clusterUri.getHost(), clusterUri.getPort(), "/", null, null);
        }
        if (clusterUri.getPath().trim() == "") {
            return new URI(clusterUri.getScheme(), null, clusterUri.getHost(), clusterUri.getPort(), "/", null, null);
        }
        return clusterUri;
    }

    @Test
    public void testReader() throws Exception {
        int expectedCount = 0;
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(new File(URI.create(this.reference))).open(new File(this.input));
        for (SAMRecord r : samReader) {
            ++expectedCount;
        }
        CRAMInputFormat inputFormat = new CRAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)1L, (long)splits.size());
        RecordReader reader = inputFormat.createRecordReader((InputSplit)splits.get(0), this.taskAttemptContext);
        reader.initialize((InputSplit)splits.get(0), this.taskAttemptContext);
        int actualCount = 0;
        while (reader.nextKeyValue()) {
            ++actualCount;
        }
        Assert.assertEquals((long)expectedCount, (long)actualCount);
    }
}

