/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.CRAMContainerStreamWriter;
import htsjdk.samtools.CRAMFileReader;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.seqdoop.hadoop_bam.CRAMInputFormat;
import org.seqdoop.hadoop_bam.KeyIgnoringCRAMOutputFormat;
import org.seqdoop.hadoop_bam.SAMFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;
import org.seqdoop.hadoop_bam.util.SAMOutputPreparer;

public class TestCRAMOutputFormat {
    private String testCRAMFileName;
    private String testReferenceFileName;
    private ReferenceSource testReferenceSource;
    private int expectedRecordCount;
    private SAMFileHeader samFileHeader;
    private TaskAttemptContext taskAttemptContext;
    private static Configuration conf;

    @Before
    public void setup() throws Exception {
        conf = new Configuration();
        this.testCRAMFileName = ClassLoader.getSystemClassLoader().getResource("test.cram").getFile();
        this.testReferenceFileName = ClassLoader.getSystemClassLoader().getResource("auxf.fa").getFile();
        this.testReferenceSource = new ReferenceSource(Paths.get(this.testReferenceFileName, new String[0]));
        conf.set("mapred.input.dir", "file://" + this.testCRAMFileName);
        conf.set("hadoopbam.cram.reference-source-path", "file://" + this.testReferenceFileName);
        this.expectedRecordCount = this.getCRAMRecordCount(this.testCRAMFileName);
        this.samFileHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(this.testCRAMFileName), (Configuration)conf);
        this.taskAttemptContext = ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)((TaskAttemptID)Mockito.mock(TaskAttemptID.class)));
    }

    @Test
    public void testCRAMRecordWriterNoHeader() throws Exception {
        File outFile = File.createTempFile("testCRAMWriter", ".cram");
        outFile.deleteOnExit();
        Path outPath = new Path(outFile.toURI());
        CRAMTestNoHeaderOutputFormat cramOut = new CRAMTestNoHeaderOutputFormat();
        conf.set("TestBAM.header", this.testCRAMFileName);
        RecordWriter<NullWritable, SAMRecordWritable> rw = cramOut.getRecordWriter(this.taskAttemptContext, outPath);
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(new File(this.testReferenceFileName)).open(new File(this.testCRAMFileName));
        for (SAMRecord r : samReader) {
            SAMRecordWritable samRW = new SAMRecordWritable();
            samRW.set(r);
            rw.write(null, (Object)samRW);
        }
        samReader.close();
        rw.close(this.taskAttemptContext);
        int actualCount = this.verifyCRAMContainerStream(new File(outFile.getAbsolutePath()), this.samFileHeader, this.testReferenceSource, true);
        Assert.assertEquals((long)this.expectedRecordCount, (long)actualCount);
    }

    @Test
    public void testCRAMRecordWriterWithHeader() throws Exception {
        File outFile = File.createTempFile("testCRAMWriter", ".cram");
        outFile.deleteOnExit();
        Path outPath = new Path(outFile.toURI());
        CRAMTestWithHeaderOutputFormat cramOut = new CRAMTestWithHeaderOutputFormat();
        conf.set("TestBAM.header", this.testCRAMFileName);
        RecordWriter<NullWritable, SAMRecordWritable> rw = cramOut.getRecordWriter(this.taskAttemptContext, outPath);
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(new File(this.testReferenceFileName)).open(new File(this.testCRAMFileName));
        for (SAMRecord r : samReader) {
            SAMRecordWritable samRW = new SAMRecordWritable();
            samRW.set(r);
            rw.write(null, (Object)samRW);
        }
        samReader.close();
        rw.close(this.taskAttemptContext);
        int actualCount = this.verifyCRAMContainerStream(new File(outFile.getAbsolutePath()), this.samFileHeader, this.testReferenceSource, false);
        Assert.assertEquals((long)this.expectedRecordCount, (long)actualCount);
    }

    @Test
    public void testCRAMOutput() throws Exception {
        Path outputPath = this.doMapReduce(this.testCRAMFileName);
        File containerStreamFile = new File(new File(outputPath.toUri()), "part-m-00000");
        int actualCount = this.verifyCRAMContainerStream(containerStreamFile, this.samFileHeader, this.testReferenceSource, true);
        Assert.assertEquals((long)this.expectedRecordCount, (long)actualCount);
    }

    @Test
    public void testCRAMRoundTrip() throws Exception {
        Path outputPath = this.doMapReduce(this.testCRAMFileName);
        File containerStreamFile = new File(new File(outputPath.toUri()), "part-m-00000");
        ByteArrayInputStream cramStream = this.mergeCRAMContainerStream(containerStreamFile, this.samFileHeader, this.testReferenceSource, true);
        File outFile = File.createTempFile("testCRAMWriter", ".cram");
        outFile.deleteOnExit();
        Files.copy(cramStream, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        outputPath = this.doMapReduce(outFile.getAbsolutePath());
        containerStreamFile = new File(new File(outputPath.toUri()), "part-m-00000");
        int actualCount = this.verifyCRAMContainerStream(containerStreamFile, this.samFileHeader, this.testReferenceSource, true);
        Assert.assertEquals((long)this.expectedRecordCount, (long)actualCount);
    }

    private int getCRAMRecordCount(String cramFileName) {
        CRAMFileReader cramReader = new CRAMFileReader(new File(cramFileName), (File)null, this.testReferenceSource);
        SAMRecordIterator it = cramReader.getIterator();
        int recCount = 0;
        while (it.hasNext()) {
            it.next();
            ++recCount;
        }
        cramReader.close();
        return recCount;
    }

    private Path doMapReduce(String inputFile) throws Exception {
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        Path inputPath = new Path(inputFile);
        Path outputPath = fileSystem.makeQualified(new Path("target/out"));
        fileSystem.delete(outputPath, true);
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputPath});
        job.setInputFormatClass(CRAMInputFormat.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(SAMRecordWritable.class);
        conf.set("TestBAM.header", inputFile);
        job.setOutputFormatClass(CRAMTestNoHeaderOutputFormat.class);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(SAMRecordWritable.class);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        boolean success = job.waitForCompletion(true);
        Assert.assertTrue((boolean)success);
        return outputPath;
    }

    private int verifyCRAMContainerStream(File containerStreamFile, SAMFileHeader header, ReferenceSource refSource, boolean writeHeader) throws IOException {
        ByteArrayInputStream mergedStream = this.mergeCRAMContainerStream(containerStreamFile, header, refSource, writeHeader);
        CRAMFileReader resultCRAMReader = new CRAMFileReader((InputStream)mergedStream, (SeekableStream)null, refSource, ValidationStringency.DEFAULT_STRINGENCY);
        SAMRecordIterator it = resultCRAMReader.getIterator();
        int actualCount = 0;
        while (it.hasNext()) {
            it.next();
            ++actualCount;
        }
        return actualCount;
    }

    private ByteArrayInputStream mergeCRAMContainerStream(File containerStreamFile, SAMFileHeader header, ReferenceSource refSource, boolean writeHeader) throws IOException {
        ByteArrayOutputStream cramOutputStream = new ByteArrayOutputStream();
        if (writeHeader) {
            new SAMOutputPreparer().prepareForRecords((OutputStream)cramOutputStream, SAMFormat.CRAM, header);
        }
        ByteArrayOutputStream containerOutputStream = new ByteArrayOutputStream();
        Files.copy(containerStreamFile.toPath(), containerOutputStream);
        containerOutputStream.writeTo(cramOutputStream);
        CRAMContainerStreamWriter containerStreamWriter = new CRAMContainerStreamWriter((OutputStream)cramOutputStream, null, refSource, header, "CRAMTest");
        containerStreamWriter.finish(true);
        cramOutputStream.close();
        return new ByteArrayInputStream(cramOutputStream.toByteArray());
    }

    static class CRAMTestNoHeaderOutputFormat
    extends KeyIgnoringCRAMOutputFormat<NullWritable> {
        public static final String READ_HEADER_FROM_FILE = "TestBAM.header";

        CRAMTestNoHeaderOutputFormat() {
        }

        public RecordWriter<NullWritable, SAMRecordWritable> getRecordWriter(TaskAttemptContext ctx, Path outputPath) throws IOException {
            this.readSAMHeaderFrom(new Path(conf.get(READ_HEADER_FROM_FILE)), conf);
            this.setWriteHeader(false);
            return super.getRecordWriter(ctx, outputPath);
        }
    }

    static class CRAMTestWithHeaderOutputFormat
    extends KeyIgnoringCRAMOutputFormat<NullWritable> {
        public static final String READ_HEADER_FROM_FILE = "TestBAM.header";

        CRAMTestWithHeaderOutputFormat() {
        }

        public RecordWriter<NullWritable, SAMRecordWritable> getRecordWriter(TaskAttemptContext ctx, Path outputPath) throws IOException {
            this.readSAMHeaderFrom(new Path(conf.get(READ_HEADER_FROM_FILE)), conf);
            this.setWriteHeader(true);
            return super.getRecordWriter(ctx, outputPath);
        }
    }
}

