/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.seqdoop.hadoop_bam.LineReader;

public class TestLineReader {
    public static final String input10 = "0123456789";
    public static final String input22 = "0123456789\n0987654321\n";
    private LineReader reader;
    private Text dest = new Text();

    @Test
    public void testReadBufferedLine() throws IOException {
        this.reader = new LineReader((InputStream)new ByteArrayInputStream(input22.getBytes()), 22);
        this.reader.readLine(this.dest);
        Assert.assertEquals((Object)input10, (Object)this.dest.toString());
    }

    @Test
    public void testSkipOnBufferedLine() throws IOException {
        this.reader = new LineReader((InputStream)new ByteArrayInputStream(input22.getBytes()), 22);
        long skipped = this.reader.skip(1L);
        Assert.assertEquals((long)1L, (long)skipped);
        this.reader.readLine(this.dest);
        Assert.assertEquals((Object)"123456789", (Object)this.dest.toString());
    }

    @Test
    public void testReadBeyondBuffer() throws IOException {
        this.reader = new LineReader((InputStream)new ByteArrayInputStream(input22.getBytes()), 5);
        this.reader.readLine(this.dest);
        Assert.assertEquals((Object)input10, (Object)this.dest.toString());
    }

    @Test
    public void testSkipBeyondBuffer() throws IOException {
        this.reader = new LineReader((InputStream)new ByteArrayInputStream(input22.getBytes()), 5);
        long skipped = this.reader.skip(11L);
        Assert.assertEquals((long)11L, (long)skipped);
        this.reader.readLine(this.dest);
        Assert.assertEquals((Object)"0987654321", (Object)this.dest.toString());
    }

    @Test
    public void testSkipBeyondInput() throws IOException {
        this.reader = new LineReader((InputStream)new ByteArrayInputStream(input10.getBytes()), 5);
        long skipped = this.reader.skip(11L);
        Assert.assertEquals((long)10L, (long)skipped);
        skipped = this.reader.skip(11L);
        Assert.assertEquals((long)0L, (long)skipped);
    }
}

