/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.seqdoop.hadoop_bam.SAMFormat;

public class TestSAMFormat {
    @Test
    public void testInferFromFilePath() throws IOException {
        Assert.assertEquals((Object)SAMFormat.SAM, (Object)SAMFormat.inferFromFilePath((String)"test.sam"));
        Assert.assertEquals((Object)SAMFormat.BAM, (Object)SAMFormat.inferFromFilePath((String)"test.bam"));
        Assert.assertEquals((Object)SAMFormat.CRAM, (Object)SAMFormat.inferFromFilePath((String)"test.cram"));
        Assert.assertNull((Object)SAMFormat.inferFromFilePath((String)"test.vcf"));
    }

    @Test
    public void testInferFromData() throws IOException {
        Assert.assertEquals((Object)SAMFormat.SAM, (Object)SAMFormat.inferFromData((InputStream)this.stream("test.sam")));
        Assert.assertEquals((Object)SAMFormat.BAM, (Object)SAMFormat.inferFromData((InputStream)this.stream("test.bam")));
        Assert.assertEquals((Object)SAMFormat.CRAM, (Object)SAMFormat.inferFromData((InputStream)this.stream("test.cram")));
        Assert.assertNull((Object)SAMFormat.inferFromData((InputStream)this.stream("test.vcf")));
    }

    private InputStream stream(String resource) throws IOException {
        return ClassLoader.getSystemClassLoader().getResource(resource).openStream();
    }
}

