/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.seqdoop.hadoop_bam.SplittingBAMIndex;
import org.seqdoop.hadoop_bam.SplittingBAMIndexer;

public class TestSplittingBAMIndexer {
    private String input;

    @Before
    public void setup() throws Exception {
        this.input = ClassLoader.getSystemClassLoader().getResource("test.bam").getFile();
    }

    @Test
    public void testIndexersProduceSameIndexes() throws Exception {
        long bamFileSize = new File(this.input).length();
        for (int g : new int[]{2, 10, 4096}) {
            SplittingBAMIndex index1 = this.fromBAMFile(g);
            SplittingBAMIndex index2 = this.fromSAMRecords(g);
            Assert.assertEquals((Object)index1, (Object)index2);
            Assert.assertEquals((long)bamFileSize, (long)index1.bamSize());
            Assert.assertEquals((long)bamFileSize, (long)index2.bamSize());
        }
    }

    private SplittingBAMIndex fromBAMFile(int granularity) throws IOException {
        Configuration conf = new Configuration();
        conf.set("input", new File(this.input).toURI().toString());
        conf.setInt("granularity", granularity);
        SplittingBAMIndexer.run((Configuration)conf);
        File indexFile = new File(this.input + ".splitting-bai");
        Assert.assertTrue((boolean)indexFile.exists());
        return new SplittingBAMIndex(indexFile);
    }

    private SplittingBAMIndex fromSAMRecords(int granularity) throws IOException {
        File indexFile = new File(this.input + ".splitting-bai");
        FileOutputStream out = new FileOutputStream(indexFile);
        SplittingBAMIndexer indexer = new SplittingBAMIndexer((OutputStream)out, granularity);
        SamReader samReader = SamReaderFactory.makeDefault().enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS}).open(new File(this.input));
        for (SAMRecord r : samReader) {
            indexer.processAlignment(r);
        }
        indexer.finish(new File(this.input).length());
        out.close();
        Assert.assertTrue((boolean)indexFile.exists());
        return new SplittingBAMIndex(indexFile);
    }
}

