/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.seqdoop.hadoop_bam.VCFInputFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;

public class TestVCFInputFormat {
    private VariantContextWritable writable;
    private RecordReader<LongWritable, VariantContextWritable> reader;
    private TaskAttemptContext taskAttemptContext;

    @Before
    public void setup() throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, InterruptedException, NoSuchFieldException {
        Configuration conf = new Configuration();
        String input_file = ClassLoader.getSystemClassLoader().getResource("test.vcf").getFile();
        conf.set("hadoopbam.vcf.trust-exts", "true");
        conf.set("mapred.input.dir", "file://" + input_file);
        this.taskAttemptContext = ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)((TaskAttemptID)Mockito.mock(TaskAttemptID.class)));
        JobContext ctx = ContextUtil.newJobContext((Configuration)conf, (JobID)this.taskAttemptContext.getJobID());
        VCFInputFormat inputFormat = new VCFInputFormat(conf);
        List splits = inputFormat.getSplits(ctx);
        this.reader = inputFormat.createRecordReader((InputSplit)splits.get(0), this.taskAttemptContext);
        this.reader.initialize((InputSplit)splits.get(0), this.taskAttemptContext);
    }

    @Test
    public void countEntries() throws Exception {
        int counter = 0;
        while (this.reader.nextKeyValue()) {
            this.writable = (VariantContextWritable)this.reader.getCurrentValue();
            assert (this.writable != null && this.writable.get() != null);
            VariantContext vc = this.writable.get();
            String value = vc.toString();
            assert (value != null);
            ++counter;
        }
        assert (counter == 5);
    }

    @Test
    public void testFirstSecond() throws Exception {
        if (!this.reader.nextKeyValue()) {
            throw new Exception("could not read first VariantContext");
        }
        this.writable = (VariantContextWritable)this.reader.getCurrentValue();
        assert (this.writable != null && this.writable.get() != null);
        VariantContext vc = this.writable.get();
        assert (vc.getContig().equals("20"));
        assert (vc.getStart() == 14370 && vc.getEnd() == 14370);
        assert (vc.getReference().getBaseString().equals("G"));
        assert (vc.getAlternateAllele(0).getBaseString().equals("A"));
        if (!this.reader.nextKeyValue()) {
            throw new Exception("could not read second VariantContext");
        }
        this.writable = (VariantContextWritable)this.reader.getCurrentValue();
        assert (this.writable != null && this.writable.get() != null);
        vc = this.writable.get();
        assert (vc.getContig().equals("20"));
        assert (vc.getStart() == 17330 && vc.getEnd() == 17330);
        assert (vc.getReference().getBaseString().equals("T"));
        assert (vc.getAlternateAllele(0).getBaseString().equals("A"));
    }
}

