/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.seqdoop.hadoop_bam.KeyIgnoringVCFOutputFormat;
import org.seqdoop.hadoop_bam.LazyParsingGenotypesContext;
import org.seqdoop.hadoop_bam.LazyVCFGenotypesContext;
import org.seqdoop.hadoop_bam.VariantContextWithHeader;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.seqdoop.hadoop_bam.util.VCFHeaderReader;

public class TestVCFOutputFormat {
    private VariantContextWritable writable;
    private RecordWriter<Long, VariantContextWritable> writer;
    private TaskAttemptContext taskAttemptContext;
    private File test_vcf_output;

    @Before
    public void setup() throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.test_vcf_output = File.createTempFile("test_vcf_output", "");
        this.test_vcf_output.delete();
        this.writable = new VariantContextWritable();
        Configuration conf = new Configuration();
        conf.set("hadoopbam.vcf.output-format", "VCF");
        KeyIgnoringVCFOutputFormat outputFormat = new KeyIgnoringVCFOutputFormat(conf);
        outputFormat.setHeader(this.readHeader());
        this.taskAttemptContext = ContextUtil.newTaskAttemptContext((Configuration)conf, (org.apache.hadoop.mapreduce.TaskAttemptID)((org.apache.hadoop.mapreduce.TaskAttemptID)Mockito.mock(TaskAttemptID.class)));
        this.writer = outputFormat.getRecordWriter(this.taskAttemptContext, new Path("file://" + this.test_vcf_output));
    }

    @After
    public void cleanup() throws IOException {
        FileUtil.fullyDelete((File)this.test_vcf_output);
    }

    private void skipHeader(LineNumberReader reader) throws IOException {
        String line = reader.readLine();
        while (line.startsWith("#")) {
            reader.mark(1000);
            line = reader.readLine();
        }
        reader.reset();
    }

    @Test
    public void testSimple() throws Exception {
        VariantContextBuilder vctx_builder = new VariantContextBuilder();
        ArrayList<Allele> alleles = new ArrayList<Allele>();
        alleles.add(Allele.create((String)"A", (boolean)false));
        alleles.add(Allele.create((String)"C", (boolean)true));
        vctx_builder.alleles(alleles);
        GenotypesContext genotypes = GenotypesContext.NO_GENOTYPES;
        vctx_builder.genotypes(genotypes);
        HashSet filters = new HashSet();
        vctx_builder.filters(filters);
        HashMap<String, Integer> attributes = new HashMap<String, Integer>();
        attributes.put("NS", new Integer(4));
        vctx_builder.attributes(attributes);
        vctx_builder.loc("20", 2L, 2L);
        vctx_builder.log10PError(-8.0);
        Object[] expected = new String[]{"20", "2", ".", "C", "A", "80", "PASS", "NS=4"};
        VariantContext ctx = vctx_builder.make();
        this.writable.set(ctx);
        this.writer.write((Object)1L, (Object)this.writable);
        this.writer.close(this.taskAttemptContext);
        LineNumberReader reader = new LineNumberReader(new FileReader(this.test_vcf_output));
        this.skipHeader(reader);
        Object[] fields = Arrays.copyOf(reader.readLine().split("\t"), expected.length);
        Assert.assertArrayEquals((String)"comparing VCF single line", (Object[])expected, (Object[])fields);
    }

    @Test
    public void testVariantContextReadWrite() throws IOException, InterruptedException {
        VariantContextBuilder vctx_builder = new VariantContextBuilder();
        ArrayList<Allele> alleles = new ArrayList<Allele>();
        alleles.add(Allele.create((String)"C", (boolean)false));
        alleles.add(Allele.create((String)"G", (boolean)true));
        vctx_builder.alleles(alleles);
        ArrayList<Genotype> genotypes = new ArrayList<Genotype>();
        GenotypeBuilder builder = new GenotypeBuilder();
        genotypes.add(builder.alleles(alleles.subList(0, 1)).name("NA00001").GQ(48).DP(1).make());
        genotypes.add(builder.alleles(alleles.subList(0, 1)).name("NA00002").GQ(42).DP(2).make());
        genotypes.add(builder.alleles(alleles.subList(0, 1)).name("NA00003").GQ(39).DP(3).make());
        vctx_builder.genotypes(genotypes);
        HashSet filters = new HashSet();
        vctx_builder.filters(filters);
        HashMap<String, Integer> attributes = new HashMap<String, Integer>();
        attributes.put("NS", new Integer(4));
        vctx_builder.attributes(attributes);
        vctx_builder.loc("20", 2L, 2L);
        vctx_builder.log10PError(-8.0);
        VariantContext ctx = vctx_builder.make();
        VariantContextWithHeader ctxh = new VariantContextWithHeader(ctx, this.readHeader());
        this.writable.set((VariantContext)ctxh);
        DataOutputBuffer out = new DataOutputBuffer(1000);
        this.writable.write((DataOutput)out);
        byte[] data = out.getData();
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.writable = new VariantContextWritable();
        this.writable.readFields((DataInput)new DataInputStream(bis));
        VariantContext vc = this.writable.get();
        Assert.assertArrayEquals((String)"comparing Alleles", (Object[])ctx.getAlleles().toArray(), (Object[])vc.getAlleles().toArray());
        Assert.assertEquals((String)"comparing Log10PError", (double)ctx.getLog10PError(), (double)vc.getLog10PError(), (double)0.01);
        Assert.assertArrayEquals((String)"comparing Filters", (Object[])ctx.getFilters().toArray(), (Object[])vc.getFilters().toArray());
        Assert.assertEquals((String)"comparing Attributes", (Object)ctx.getAttributes(), (Object)vc.getAttributes());
        GenotypesContext gc = vc.getGenotypes();
        assert (gc instanceof LazyVCFGenotypesContext);
        LazyVCFGenotypesContext.HeaderDataCache headerDataCache = new LazyVCFGenotypesContext.HeaderDataCache();
        headerDataCache.setHeader(this.readHeader());
        ((LazyVCFGenotypesContext)gc).getParser().setHeaderDataCache((LazyParsingGenotypesContext.HeaderDataCache)headerDataCache);
        for (Genotype genotype : genotypes) {
            Assert.assertEquals((String)"checking genotype name", (Object)genotype.getSampleName(), (Object)gc.get(genotypes.indexOf(genotype)).getSampleName());
            Assert.assertEquals((String)"checking genotype quality", (long)genotype.getGQ(), (long)gc.get(genotypes.indexOf(genotype)).getGQ());
            Assert.assertEquals((String)"checking genotype read depth", (long)genotype.getDP(), (long)gc.get(genotypes.indexOf(genotype)).getDP());
        }
    }

    private VCFHeader readHeader() throws IOException {
        String header_file = ClassLoader.getSystemClassLoader().getResource("test.vcf").getFile();
        VCFHeader header = VCFHeaderReader.readHeaderFrom((SeekableStream)new SeekableFileStream(new File(header_file)));
        return header;
    }
}

