/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.FileTruncatedException;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.GenericOptionsParser;
import org.seqdoop.hadoop_bam.LazyBAMRecordFactory;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;
import org.seqdoop.hadoop_bam.util.SeekableArrayStream;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public class BAMSplitGuesser {
    private SeekableStream inFile;
    private SeekableStream in;
    private BlockCompressedInputStream bgzf;
    private final BAMRecordCodec bamCodec;
    private final ByteBuffer buf;
    private final int referenceSequenceCount;
    private static final byte BLOCKS_NEEDED_FOR_GUESS = 3;
    private static final int MAX_BYTES_READ = 262139;
    private static final int BGZF_MAGIC = 67668767;
    private static final int BGZF_MAGIC_SUB = 148290;
    private static final int BGZF_SUB_SIZE = 6;
    private static final int SHORTEST_POSSIBLE_BAM_RECORD = 39;

    public BAMSplitGuesser(SeekableStream ss, Configuration conf) throws IOException {
        this(ss, (InputStream)ss, conf);
        ss.seek(0L);
        if (ss.read(this.buf.array(), 0, 4) != 4 || this.buf.getInt(0) != 67668767) {
            throw new SAMFormatException("Does not seem like a BAM file");
        }
    }

    public BAMSplitGuesser(SeekableStream ss, InputStream headerStream, Configuration conf) throws IOException {
        this.inFile = ss;
        this.buf = ByteBuffer.allocate(8);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
        this.referenceSequenceCount = SAMHeaderReader.readSAMHeaderFrom(headerStream, conf).getSequenceDictionary().size();
        this.bamCodec = new BAMRecordCodec(null, (SAMRecordFactory)new LazyBAMRecordFactory());
    }

    public long guessNextBAMRecordStart(long beg, long end) throws IOException {
        int r;
        byte[] arr = new byte[262139];
        this.inFile.seek(beg);
        int totalRead = 0;
        for (int left = Math.min((int)(end - beg), arr.length); left > 0 && (r = this.inFile.read(arr, totalRead, left)) >= 0; left -= r) {
            totalRead += r;
        }
        arr = Arrays.copyOf(arr, totalRead);
        this.in = new SeekableArrayStream(arr);
        this.bgzf = new BlockCompressedInputStream(this.in);
        this.bgzf.setCheckCrcs(true);
        this.bamCodec.setInputStream((InputStream)this.bgzf);
        int firstBGZFEnd = Math.min((int)(end - beg), 65535);
        int cp = 0;
        while (true) {
            block18: {
                int up0;
                PosSize psz;
                if ((psz = this.guessNextBGZFPos(cp, firstBGZFEnd)) == null) {
                    return end;
                }
                int cp0 = cp = psz.pos;
                long cp0Virt = (long)cp0 << 16;
                try {
                    this.bgzf.seek(cp0Virt);
                }
                catch (Throwable e) {
                    break block18;
                }
                int up = 0;
                while ((up0 = (up = this.guessNextBAMPos(cp0Virt, up, psz.size))) >= 0) {
                    block20: {
                        block19: {
                            this.bgzf.seek(cp0Virt | (long)up0);
                            boolean decodedAny = false;
                            try {
                                SAMRecord record;
                                int b = 0;
                                int prevCP = cp0;
                                while (b < 3 && (record = this.bamCodec.decode()) != null) {
                                    record.getCigar();
                                    decodedAny = true;
                                    int cp2 = (int)(this.bgzf.getFilePointer() >>> 16);
                                    if (cp2 == prevCP) continue;
                                    assert (cp2 > prevCP);
                                    prevCP = cp2;
                                    b = (byte)(b + 1);
                                }
                                if (b >= 3) break block19;
                                assert (arr.length < 262139);
                                if (!decodedAny) {
                                }
                                break block19;
                            }
                            catch (SAMFormatException e) {
                            }
                            catch (OutOfMemoryError e) {
                            }
                            catch (IllegalArgumentException e) {
                            }
                            catch (RuntimeIOException e) {
                            }
                            catch (FileTruncatedException e) {
                                if (!decodedAny && this.in.eof()) {
                                }
                                break block19;
                            }
                            catch (RuntimeEOFException e) {
                                if (decodedAny || !this.in.eof()) break block19;
                            }
                            break block20;
                        }
                        return beg + (long)cp0 << 16 | (long)up0;
                    }
                    ++up;
                }
            }
            ++cp;
        }
    }

    private PosSize guessNextBGZFPos(int p, int end) {
        try {
            while (true) {
                this.in.seek((long)p);
                IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)4);
                int n = this.buf.getInt(0);
                if (n != 67668767) {
                    p = n >>> 8 == 559903 ? ++p : (n >>> 16 == 35615 ? (p += 2) : (p += 3));
                    if (p < end) continue;
                    return null;
                }
                int p0 = p;
                this.in.seek((long)(p += 10));
                IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)2);
                int xlen = this.getUShort(0);
                int subEnd = (p += 2) + xlen;
                while (p < subEnd) {
                    IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)4);
                    if (this.buf.getInt(0) != 148290) {
                        this.in.seek((long)(p += 4 + this.getUShort(2)));
                        continue;
                    }
                    IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)2);
                    int bsize = this.getUShort(0);
                    p += 6;
                    while (p < subEnd) {
                        this.in.seek((long)p);
                        IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)4);
                        p += 4 + this.getUShort(2);
                    }
                    if (p != subEnd) break;
                    this.in.seek((long)(p += bsize - xlen - 19 + 4));
                    IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)4);
                    return new PosSize(p0, this.buf.getInt(0));
                }
                p = p0 + 4;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private int guessNextBAMPos(long cpVirt, int up, int cSize) {
        up += 4;
        try {
            while (up + 39 - 4 < cSize) {
                this.bgzf.seek(cpVirt | (long)up);
                IOUtils.readFully((InputStream)this.bgzf, (byte[])this.buf.array(), (int)0, (int)8);
                int id = this.buf.getInt(0);
                int pos = this.buf.getInt(4);
                if (id < -1 || id > this.referenceSequenceCount || pos < -1) {
                    ++up;
                    continue;
                }
                this.bgzf.seek(cpVirt | (long)(up + 20));
                IOUtils.readFully((InputStream)this.bgzf, (byte[])this.buf.array(), (int)0, (int)8);
                int nid = this.buf.getInt(0);
                int npos = this.buf.getInt(4);
                if (nid < -1 || nid > this.referenceSequenceCount || npos < -1) {
                    ++up;
                    continue;
                }
                int nextUP = up + 1;
                this.bgzf.seek(cpVirt | (long)((up -= 4) + 12));
                IOUtils.readFully((InputStream)this.bgzf, (byte[])this.buf.array(), (int)0, (int)4);
                int nameLength = this.buf.getInt(0) & 0xFF;
                if (nameLength < 1) {
                    up = nextUP;
                    continue;
                }
                int nullTerminator = up + 36 + nameLength - 1;
                if (nullTerminator >= cSize) {
                    up = nextUP;
                    continue;
                }
                this.bgzf.seek(cpVirt | (long)nullTerminator);
                IOUtils.readFully((InputStream)this.bgzf, (byte[])this.buf.array(), (int)0, (int)1);
                if (this.buf.get(0) != 0) {
                    up = nextUP;
                    continue;
                }
                int zeroMin = 32 + nameLength;
                this.bgzf.seek(cpVirt | (long)(up + 16));
                IOUtils.readFully((InputStream)this.bgzf, (byte[])this.buf.array(), (int)0, (int)8);
                zeroMin += (this.buf.getInt(0) & 0xFFFF) * 4;
                this.bgzf.seek(cpVirt | (long)up);
                IOUtils.readFully((InputStream)this.bgzf, (byte[])this.buf.array(), (int)0, (int)4);
                if (this.buf.getInt(0) < (zeroMin += this.buf.getInt(4) + (this.buf.getInt(4) + 1) / 2)) {
                    up = nextUP;
                    continue;
                }
                return up;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    private int getUShort(int idx) {
        return this.buf.getShort(idx) & 0xFFFF;
    }

    public static void main(String[] args) throws IOException {
        GenericOptionsParser parser;
        try {
            parser = new GenericOptionsParser(args);
        }
        catch (Exception e) {
            System.err.printf("Error in Hadoop arguments: %s\n", e.getMessage());
            System.exit(1);
            return;
        }
        args = parser.getRemainingArgs();
        Configuration conf = parser.getConfiguration();
        long beg = 0L;
        if (args.length < 2 || args.length > 3) {
            System.err.println("Usage: BAMSplitGuesser path-or-uri header-path-or-uri [beg]");
            System.exit(2);
        }
        try {
            if (args.length > 2) {
                beg = Long.decode(args[2]);
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid beg offset.");
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            }
            System.exit(2);
        }
        WrapSeekable<FSDataInputStream> ss = WrapSeekable.openPath(conf, new Path(args[0]));
        WrapSeekable<FSDataInputStream> hs = WrapSeekable.openPath(conf, new Path(args[1]));
        long end = beg + 262139L;
        System.out.printf("Will look for a BGZF block within: [%1$#x,%2$#x) = [%1$d,%2$d)\nWill then verify BAM data within:  [%1$#x,%3$#x) = [%1$d,%3$d)\n", beg, beg + 65535L, end);
        long g = new BAMSplitGuesser(ss, (InputStream)((Object)hs), conf).guessNextBAMRecordStart(beg, end);
        ss.close();
        if (g == end) {
            System.out.println("Didn't find any acceptable BAM record in any BGZF block.");
            System.exit(1);
        }
        System.out.printf("Accepted BGZF block at offset %1$#x (%1$d).\nAccepted BAM record at offset %2$#x (%2$d) therein.\n", g >> 16, g & 0xFFFFL);
    }

    private static class PosSize {
        public int pos;
        public int size;

        public PosSize(int p, int s) {
            this.pos = p;
            this.size = s;
        }
    }
}

