/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.BCFStoppableOutputStream;
import org.seqdoop.hadoop_bam.LazyBCFGenotypesContext;
import org.seqdoop.hadoop_bam.LazyParsingGenotypesContext;
import org.seqdoop.hadoop_bam.LazyVCFGenotypesContext;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.seqdoop.hadoop_bam.util.VCFHeaderReader;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public abstract class BCFRecordWriter<K>
extends RecordWriter<K, VariantContextWritable> {
    private VariantContextWriter writer;
    private LazyVCFGenotypesContext.HeaderDataCache vcfHeaderDataCache = new LazyVCFGenotypesContext.HeaderDataCache();
    private LazyBCFGenotypesContext.HeaderDataCache bcfHeaderDataCache = new LazyBCFGenotypesContext.HeaderDataCache();

    public BCFRecordWriter(Path output, Path input, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        WrapSeekable<FSDataInputStream> in = WrapSeekable.openPath(ContextUtil.getConfiguration((JobContext)ctx), input);
        VCFHeader header = VCFHeaderReader.readHeaderFrom(in);
        in.close();
        this.init(output, header, writeHeader, ctx);
    }

    public BCFRecordWriter(Path output, VCFHeader header, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init((OutputStream)output.getFileSystem(ContextUtil.getConfiguration((JobContext)ctx)).create(output), header, writeHeader);
    }

    public BCFRecordWriter(OutputStream output, VCFHeader header, boolean writeHeader) throws IOException {
        this.init(output, header, writeHeader);
    }

    private void init(Path output, VCFHeader header, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init((OutputStream)output.getFileSystem(ContextUtil.getConfiguration((JobContext)ctx)).create(output), header, writeHeader);
    }

    private void init(OutputStream output, VCFHeader header, boolean writeHeader) throws IOException {
        BCFStoppableOutputStream stopOut = new BCFStoppableOutputStream(!writeHeader, output);
        this.writer = new VariantContextWriterBuilder().clearOptions().setOption(Options.FORCE_BCF).setOutputBCFStream((OutputStream)stopOut).build();
        this.writer.writeHeader(header);
        stopOut.stopped = false;
        this.setInputHeader(header);
    }

    public void close(TaskAttemptContext ctx) throws IOException {
        this.writer.close();
    }

    public void setInputHeader(VCFHeader header) {
        this.vcfHeaderDataCache.setHeader(header);
        this.bcfHeaderDataCache.setHeader(header);
    }

    protected void writeRecord(VariantContext vc) {
        GenotypesContext gc = vc.getGenotypes();
        if (gc instanceof LazyParsingGenotypesContext) {
            ((LazyParsingGenotypesContext)gc).getParser().setHeaderDataCache(gc instanceof LazyVCFGenotypesContext ? this.vcfHeaderDataCache : this.bcfHeaderDataCache);
        }
        this.writer.add(vc);
    }
}

