/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.FormatConstants;
import org.seqdoop.hadoop_bam.FormatException;
import org.seqdoop.hadoop_bam.LineReader;
import org.seqdoop.hadoop_bam.SequencedFragment;
import org.seqdoop.hadoop_bam.util.ConfHelper;

public class FastqInputFormat
extends FileInputFormat<Text, SequencedFragment> {
    public static final String CONF_BASE_QUALITY_ENCODING = "hbam.fastq-input.base-quality-encoding";
    public static final String CONF_FILTER_FAILED_QC = "hbam.fastq-input.filter-failed-qc";
    public static final String CONF_BASE_QUALITY_ENCODING_DEFAULT = "sanger";

    public boolean isSplitable(JobContext context, Path path) {
        CompressionCodec codec = new CompressionCodecFactory(ContextUtil.getConfiguration(context)).getCodec(path);
        return codec == null;
    }

    public RecordReader<Text, SequencedFragment> createRecordReader(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        context.setStatus(genericSplit.toString());
        return new FastqRecordReader(ContextUtil.getConfiguration((JobContext)context), (FileSplit)genericSplit);
    }

    public static class FastqRecordReader
    extends RecordReader<Text, SequencedFragment> {
        private long start;
        private long end;
        private long pos;
        private Path file;
        private LineReader lineReader;
        private InputStream inputStream;
        private Text currentKey = new Text();
        private SequencedFragment currentValue = new SequencedFragment();
        private boolean lookForIlluminaIdentifier = true;
        private static final Pattern ILLUMINA_PATTERN = Pattern.compile("([^:]+):(\\d+):([^:]*):(\\d+):(\\d+):(-?\\d+):(-?\\d+)\\s+([123]):([YN]):(\\d+):(.*)");
        private Text buffer = new Text();
        private FormatConstants.BaseQualityEncoding qualityEncoding;
        private boolean filterFailedQC = false;
        private static final int MAX_LINE_LENGTH = 10000;

        public FastqRecordReader(Configuration conf, FileSplit split) throws IOException {
            this.setConf(conf);
            this.file = split.getPath();
            this.start = split.getStart();
            this.end = this.start + split.getLength();
            FileSystem fs = this.file.getFileSystem(conf);
            FSDataInputStream fileIn = fs.open(this.file);
            CompressionCodecFactory codecFactory = new CompressionCodecFactory(conf);
            CompressionCodec codec = codecFactory.getCodec(this.file);
            if (codec == null) {
                this.positionAtFirstRecord(fileIn);
                this.inputStream = fileIn;
            } else {
                if (this.start != 0L) {
                    throw new RuntimeException("Start position for compressed file is not 0! (found " + this.start + ")");
                }
                this.inputStream = codec.createInputStream((InputStream)fileIn);
                this.end = Long.MAX_VALUE;
            }
            this.lineReader = new LineReader(this.inputStream);
        }

        protected void setConf(Configuration conf) {
            String encoding = conf.get(FastqInputFormat.CONF_BASE_QUALITY_ENCODING, conf.get("hbam.input.base-quality-encoding", FastqInputFormat.CONF_BASE_QUALITY_ENCODING_DEFAULT));
            if ("illumina".equals(encoding)) {
                this.qualityEncoding = FormatConstants.BaseQualityEncoding.Illumina;
            } else if (FastqInputFormat.CONF_BASE_QUALITY_ENCODING_DEFAULT.equals(encoding)) {
                this.qualityEncoding = FormatConstants.BaseQualityEncoding.Sanger;
            } else {
                throw new RuntimeException("Unknown input base quality encoding value " + encoding);
            }
            this.filterFailedQC = ConfHelper.parseBoolean(conf.get(FastqInputFormat.CONF_FILTER_FAILED_QC, conf.get("hbam.input.filter-failed-qc")), false);
        }

        private void positionAtFirstRecord(FSDataInputStream stream) throws IOException {
            if (this.start > 0L) {
                stream.seek(this.start);
                LineReader reader = new LineReader((InputStream)stream);
                int bytesRead = 0;
                do {
                    if ((bytesRead = reader.readLine(this.buffer, (int)Math.min(10000L, this.end - this.start))) > 0 && (this.buffer.getLength() <= 0 || this.buffer.getBytes()[0] != 64)) {
                        this.start += (long)bytesRead;
                        continue;
                    }
                    long backtrackPosition = this.start + (long)bytesRead;
                    bytesRead = reader.readLine(this.buffer, (int)Math.min(10000L, this.end - this.start));
                    bytesRead = reader.readLine(this.buffer, (int)Math.min(10000L, this.end - this.start));
                    if (bytesRead > 0 && this.buffer.getLength() > 0 && this.buffer.getBytes()[0] == 43) break;
                    this.start = backtrackPosition;
                    stream.seek(this.start);
                    reader = new LineReader((InputStream)stream);
                } while (bytesRead > 0);
                stream.seek(this.start);
            }
            this.pos = this.start;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public Text getCurrentKey() {
            return this.currentKey;
        }

        public SequencedFragment getCurrentValue() {
            return this.currentValue;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.next(this.currentKey, this.currentValue);
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public Text createKey() {
            return new Text();
        }

        public SequencedFragment createValue() {
            return new SequencedFragment();
        }

        public long getPos() {
            return this.pos;
        }

        public float getProgress() {
            if (this.start == this.end) {
                return 1.0f;
            }
            return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
        }

        public String makePositionMessage() {
            return this.file.toString() + ":" + this.pos;
        }

        protected boolean lowLevelFastqRead(Text key, SequencedFragment value) throws IOException {
            long skipped = this.lineReader.skip(1L);
            this.pos += skipped;
            if (skipped == 0L) {
                return false;
            }
            this.readLineInto(key);
            value.clear();
            this.readLineInto(value.getSequence());
            this.readLineInto(this.buffer);
            if (this.buffer.getLength() == 0 || this.buffer.getBytes()[0] != 43) {
                throw new RuntimeException("unexpected fastq line separating sequence and quality at " + this.makePositionMessage() + ". Line: " + this.buffer + ". \nSequence ID: " + key);
            }
            this.readLineInto(value.getQuality());
            boolean bl = this.lookForIlluminaIdentifier = this.lookForIlluminaIdentifier && this.scanIlluminaId(key, value);
            if (!this.lookForIlluminaIdentifier) {
                this.scanNameForReadNumber(key, value);
            }
            return true;
        }

        public boolean next(Text key, SequencedFragment value) throws IOException {
            if (this.pos >= this.end) {
                return false;
            }
            try {
                boolean goodRecord;
                boolean gotData;
                do {
                    boolean bl = goodRecord = (gotData = this.lowLevelFastqRead(key, value)) && (!this.filterFailedQC || value.getFilterPassed() == null || value.getFilterPassed() != false);
                } while (gotData && !goodRecord);
                if (goodRecord) {
                    if (this.qualityEncoding == FormatConstants.BaseQualityEncoding.Illumina) {
                        try {
                            SequencedFragment.convertQuality(value.getQuality(), FormatConstants.BaseQualityEncoding.Illumina, FormatConstants.BaseQualityEncoding.Sanger);
                        }
                        catch (FormatException e) {
                            throw new FormatException(e.getMessage() + " Position: " + this.makePositionMessage() + "; Sequence ID: " + key);
                        }
                    } else {
                        int outOfRangeElement = SequencedFragment.verifyQuality(value.getQuality(), FormatConstants.BaseQualityEncoding.Sanger);
                        if (outOfRangeElement >= 0) {
                            throw new FormatException("fastq base quality score out of range for Sanger Phred+33 format (found " + (value.getQuality().getBytes()[outOfRangeElement] - 33) + ").\n" + "Although Sanger format has been requested, maybe qualities are in Illumina Phred+64 format?\n" + "Position: " + this.makePositionMessage() + "; Sequence ID: " + key);
                        }
                    }
                }
                return goodRecord;
            }
            catch (EOFException e) {
                throw new RuntimeException("unexpected end of file in fastq record at " + this.makePositionMessage() + ".  Id: " + key.toString());
            }
        }

        private void scanNameForReadNumber(Text name, SequencedFragment fragment) {
            int last;
            byte[] bytes;
            if (name.getLength() >= 2 && (bytes = name.getBytes())[(last = name.getLength() - 1) - 1] == 47 && bytes[last] >= 48 && bytes[last] <= 57) {
                fragment.setRead(bytes[last] - 48);
            }
        }

        private boolean scanIlluminaId(Text name, SequencedFragment fragment) {
            Matcher m = ILLUMINA_PATTERN.matcher(name.toString());
            boolean matches = m.matches();
            if (matches) {
                fragment.setInstrument(m.group(1));
                fragment.setRunNumber(Integer.parseInt(m.group(2)));
                fragment.setFlowcellId(m.group(3));
                fragment.setLane(Integer.parseInt(m.group(4)));
                fragment.setTile(Integer.parseInt(m.group(5)));
                fragment.setXpos(Integer.parseInt(m.group(6)));
                fragment.setYpos(Integer.parseInt(m.group(7)));
                fragment.setRead(Integer.parseInt(m.group(8)));
                fragment.setFilterPassed("N".equals(m.group(9)));
                fragment.setControlNumber(Integer.parseInt(m.group(10)));
                fragment.setIndexSequence(m.group(11));
            }
            return matches;
        }

        private int readLineInto(Text dest) throws EOFException, IOException {
            int bytesRead = this.lineReader.readLine(dest, 10000);
            if (bytesRead <= 0) {
                throw new EOFException();
            }
            this.pos += (long)bytesRead;
            return bytesRead;
        }
    }
}

