/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.seqdoop.hadoop_bam.FormatConstants;
import org.seqdoop.hadoop_bam.SequencedFragment;

public class FastqOutputFormat
extends TextOutputFormat<Text, SequencedFragment> {
    public static final String CONF_BASE_QUALITY_ENCODING = "hbam.fastq-output.base-quality-encoding";
    public static final String CONF_BASE_QUALITY_ENCODING_DEFAULT = "sanger";
    public static final Charset UTF8 = Charset.forName("UTF8");
    static final byte[] PLUS_LINE;

    public RecordWriter<Text, SequencedFragment> getRecordWriter(TaskAttemptContext task) throws IOException {
        Object output;
        Configuration conf = ContextUtil.getConfiguration((JobContext)task);
        boolean isCompressed = FastqOutputFormat.getCompressOutput((JobContext)task);
        CompressionCodec codec = null;
        String extension = "";
        if (isCompressed) {
            Class codecClass = FastqOutputFormat.getOutputCompressorClass((JobContext)task, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            extension = codec.getDefaultExtension();
        }
        Path file = this.getDefaultWorkFile(task, extension);
        FileSystem fs = file.getFileSystem(conf);
        if (isCompressed) {
            FSDataOutputStream fileOut = fs.create(file, false);
            output = new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fileOut));
        } else {
            output = fs.create(file, false);
        }
        return new FastqRecordWriter(conf, (OutputStream)output);
    }

    static {
        try {
            PLUS_LINE = "\n+\n".getBytes("us-ascii");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("us-ascii encoding not supported!");
        }
    }

    public static class FastqRecordWriter
    extends RecordWriter<Text, SequencedFragment> {
        protected StringBuilder sBuilder = new StringBuilder(800);
        protected Text buffer = new Text();
        protected OutputStream out;
        protected FormatConstants.BaseQualityEncoding baseQualityFormat;

        public FastqRecordWriter(Configuration conf, OutputStream out) {
            this.out = out;
            this.setConf(conf);
        }

        public void setConf(Configuration conf) {
            String setting = conf.get(FastqOutputFormat.CONF_BASE_QUALITY_ENCODING, FastqOutputFormat.CONF_BASE_QUALITY_ENCODING_DEFAULT);
            if ("illumina".equals(setting)) {
                this.baseQualityFormat = FormatConstants.BaseQualityEncoding.Illumina;
            } else if (FastqOutputFormat.CONF_BASE_QUALITY_ENCODING_DEFAULT.equals(setting)) {
                this.baseQualityFormat = FormatConstants.BaseQualityEncoding.Sanger;
            } else {
                throw new RuntimeException("Invalid property value '" + setting + "' for " + FastqOutputFormat.CONF_BASE_QUALITY_ENCODING + ".  Valid values are 'illumina' or 'sanger'");
            }
        }

        protected String makeId(SequencedFragment seq) throws IOException {
            String delim = ":";
            this.sBuilder.delete(0, this.sBuilder.length());
            this.sBuilder.append(seq.getInstrument() == null ? "" : seq.getInstrument()).append(delim);
            this.sBuilder.append(seq.getRunNumber() == null ? "" : seq.getRunNumber().toString()).append(delim);
            this.sBuilder.append(seq.getFlowcellId() == null ? "" : seq.getFlowcellId()).append(delim);
            this.sBuilder.append(seq.getLane() == null ? "" : seq.getLane().toString()).append(delim);
            this.sBuilder.append(seq.getTile() == null ? "" : seq.getTile().toString()).append(delim);
            this.sBuilder.append(seq.getXpos() == null ? "" : seq.getXpos().toString()).append(delim);
            this.sBuilder.append(seq.getYpos() == null ? "" : seq.getYpos().toString());
            this.sBuilder.append(" ");
            this.sBuilder.append(seq.getRead() == null ? "" : seq.getRead().toString()).append(delim);
            this.sBuilder.append(seq.getFilterPassed() == null || seq.getFilterPassed() != false ? "N" : "Y");
            this.sBuilder.append(delim);
            this.sBuilder.append(seq.getControlNumber() == null ? "0" : seq.getControlNumber().toString()).append(delim);
            this.sBuilder.append(seq.getIndexSequence() == null ? "" : seq.getIndexSequence());
            return this.sBuilder.toString();
        }

        public void write(Text key, SequencedFragment seq) throws IOException {
            this.out.write(64);
            if (key != null) {
                this.out.write(key.getBytes(), 0, key.getLength());
            } else {
                this.out.write(this.makeId(seq).getBytes(UTF8));
            }
            this.out.write(10);
            this.out.write(seq.getSequence().getBytes(), 0, seq.getSequence().getLength());
            this.out.write(PLUS_LINE);
            if (this.baseQualityFormat == FormatConstants.BaseQualityEncoding.Sanger) {
                this.out.write(seq.getQuality().getBytes(), 0, seq.getQuality().getLength());
            } else if (this.baseQualityFormat == FormatConstants.BaseQualityEncoding.Illumina) {
                this.buffer.set(seq.getQuality());
                SequencedFragment.convertQuality(this.buffer, FormatConstants.BaseQualityEncoding.Sanger, this.baseQualityFormat);
                this.out.write(this.buffer.getBytes(), 0, this.buffer.getLength());
            } else {
                throw new RuntimeException("FastqOutputFormat: unknown base quality format " + (Object)((Object)this.baseQualityFormat));
            }
            this.out.write(10);
        }

        public void close(TaskAttemptContext task) throws IOException {
            this.out.close();
        }
    }
}

