/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.SAMFileHeader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.CRAMOutputFormat;
import org.seqdoop.hadoop_bam.KeyIgnoringCRAMRecordWriter;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;

public class KeyIgnoringCRAMOutputFormat<K>
extends CRAMOutputFormat<K> {
    protected SAMFileHeader header;
    private boolean writeHeader = true;

    public boolean getWriteHeader() {
        return this.writeHeader;
    }

    public void setWriteHeader(boolean b) {
        this.writeHeader = b;
    }

    public SAMFileHeader getSAMHeader() {
        return this.header;
    }

    public void setSAMHeader(SAMFileHeader header) {
        this.header = header;
    }

    public void readSAMHeaderFrom(Path path, Configuration conf) throws IOException {
        this.header = SAMHeaderReader.readSAMHeaderFrom(path, conf);
    }

    public void readSAMHeaderFrom(InputStream in, Configuration conf) {
        this.header = SAMHeaderReader.readSAMHeaderFrom(in, conf);
    }

    public RecordWriter<K, SAMRecordWritable> getRecordWriter(TaskAttemptContext ctx) throws IOException {
        return this.getRecordWriter(ctx, this.getDefaultWorkFile(ctx, ""));
    }

    public RecordWriter<K, SAMRecordWritable> getRecordWriter(TaskAttemptContext ctx, Path out) throws IOException {
        if (this.header == null) {
            throw new IOException("Can't create a RecordWriter without the SAM header");
        }
        return new KeyIgnoringCRAMRecordWriter(out, this.header, this.writeHeader, ctx);
    }
}

