/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.seqdoop.hadoop_bam.FormatConstants;
import org.seqdoop.hadoop_bam.SequencedFragment;

public class QseqOutputFormat
extends TextOutputFormat<Text, SequencedFragment> {
    public static final String CONF_BASE_QUALITY_ENCODING = "hbam.qseq-output.base-quality-encoding";
    public static final String CONF_BASE_QUALITY_ENCODING_DEFAULT = "illumina";

    public RecordWriter<Text, SequencedFragment> getRecordWriter(TaskAttemptContext task) throws IOException {
        Object output;
        Configuration conf = ContextUtil.getConfiguration((JobContext)task);
        boolean isCompressed = QseqOutputFormat.getCompressOutput((JobContext)task);
        CompressionCodec codec = null;
        String extension = "";
        if (isCompressed) {
            Class codecClass = QseqOutputFormat.getOutputCompressorClass((JobContext)task, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            extension = codec.getDefaultExtension();
        }
        Path file = this.getDefaultWorkFile(task, extension);
        FileSystem fs = file.getFileSystem(conf);
        if (isCompressed) {
            FSDataOutputStream fileOut = fs.create(file, false);
            output = new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fileOut));
        } else {
            output = fs.create(file, false);
        }
        return new QseqRecordWriter(conf, (OutputStream)output);
    }

    public static class QseqRecordWriter
    extends RecordWriter<Text, SequencedFragment> {
        static final byte[] newLine;
        static final String delim = "\t";
        protected StringBuilder sBuilder = new StringBuilder(800);
        protected OutputStream out;
        FormatConstants.BaseQualityEncoding baseQualityFormat = FormatConstants.BaseQualityEncoding.Illumina;

        public QseqRecordWriter(Configuration conf, OutputStream out) {
            this.out = out;
            this.setConf(conf);
        }

        public void setConf(Configuration conf) {
            String setting = conf.get(QseqOutputFormat.CONF_BASE_QUALITY_ENCODING, QseqOutputFormat.CONF_BASE_QUALITY_ENCODING_DEFAULT);
            if (QseqOutputFormat.CONF_BASE_QUALITY_ENCODING_DEFAULT.equals(setting)) {
                this.baseQualityFormat = FormatConstants.BaseQualityEncoding.Illumina;
            } else if ("sanger".equals(setting)) {
                this.baseQualityFormat = FormatConstants.BaseQualityEncoding.Sanger;
            } else {
                throw new RuntimeException("Invalid property value '" + setting + "' for " + QseqOutputFormat.CONF_BASE_QUALITY_ENCODING + ".  Valid values are 'illumina' or 'sanger'");
            }
        }

        public void write(Text ignored_key, SequencedFragment seq) throws IOException {
            this.sBuilder.delete(0, this.sBuilder.length());
            this.sBuilder.append(seq.getInstrument() == null ? "" : seq.getInstrument()).append(delim);
            this.sBuilder.append(seq.getRunNumber() == null ? "" : seq.getRunNumber().toString()).append(delim);
            this.sBuilder.append(seq.getLane() == null ? "" : seq.getLane().toString()).append(delim);
            this.sBuilder.append(seq.getTile() == null ? "" : seq.getTile().toString()).append(delim);
            this.sBuilder.append(seq.getXpos() == null ? "" : seq.getXpos().toString()).append(delim);
            this.sBuilder.append(seq.getYpos() == null ? "" : seq.getYpos().toString()).append(delim);
            String index = seq.getIndexSequence() == null || seq.getIndexSequence().isEmpty() ? "0" : seq.getIndexSequence().replace('N', '.');
            this.sBuilder.append(index).append(delim);
            this.sBuilder.append(seq.getRead() == null ? "" : seq.getRead().toString()).append(delim);
            this.sBuilder.append(seq.getSequence() == null ? "" : seq.getSequence().toString().replace('N', '.')).append(delim);
            if (seq.getQuality() == null) {
                this.sBuilder.append("");
            } else {
                int startPos = this.sBuilder.length();
                this.sBuilder.append(seq.getQuality().toString());
                if (this.baseQualityFormat != FormatConstants.BaseQualityEncoding.Sanger) {
                    if (this.baseQualityFormat == FormatConstants.BaseQualityEncoding.Illumina) {
                        for (int i = startPos; i < this.sBuilder.length(); ++i) {
                            char newValue = (char)(this.sBuilder.charAt(i) + 31);
                            if (newValue > '~') {
                                throw new RuntimeException("output quality score over allowed range.  Maybe you meant to write in Sanger format?");
                            }
                            this.sBuilder.setCharAt(i, newValue);
                        }
                    } else {
                        throw new RuntimeException("BUG!  Unknown base quality format value " + (Object)((Object)this.baseQualityFormat) + " in QseqRecordWriter");
                    }
                }
            }
            this.sBuilder.append(delim);
            this.sBuilder.append(seq.getFilterPassed() == null || seq.getFilterPassed() != false ? 1 : 0);
            try {
                ByteBuffer buf = Text.encode((String)this.sBuilder.toString());
                this.out.write(buf.array(), 0, buf.limit());
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException("Error encoding qseq record: " + seq);
            }
            this.out.write(newLine, 0, newLine.length);
        }

        public void close(TaskAttemptContext context) throws IOException {
            this.out.close();
        }

        static {
            try {
                newLine = "\n".getBytes("us-ascii");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("us-ascii encoding not supported!");
            }
        }
    }
}

