/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTextWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;

public abstract class SAMRecordWriter<K>
extends RecordWriter<K, SAMRecordWritable> {
    private SAMTextWriter writer;
    private SAMFileHeader header;

    public SAMRecordWriter(Path output, Path input, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init(output, SAMHeaderReader.readSAMHeaderFrom(input, ContextUtil.getConfiguration((JobContext)ctx)), writeHeader, ctx);
    }

    public SAMRecordWriter(Path output, SAMFileHeader header, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init((OutputStream)output.getFileSystem(ContextUtil.getConfiguration((JobContext)ctx)).create(output), header, writeHeader);
    }

    public SAMRecordWriter(OutputStream output, SAMFileHeader header, boolean writeHeader) throws IOException {
        this.init(output, header, writeHeader);
    }

    private void init(Path output, SAMFileHeader header, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init((OutputStream)output.getFileSystem(ContextUtil.getConfiguration((JobContext)ctx)).create(output), header, writeHeader);
    }

    private void init(OutputStream output, SAMFileHeader header, boolean writeHeader) throws IOException {
        this.header = header;
        this.writer = new SAMTextWriter(output);
        this.writer.setSortOrder(header.getSortOrder(), false);
        if (writeHeader) {
            this.writer.setHeader(header);
        }
    }

    public void close(TaskAttemptContext ctx) {
        this.writer.close();
    }

    protected void writeAlignment(SAMRecord rec) {
        rec.setHeader(this.header);
        this.writer.writeAlignment(rec);
    }
}

