/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.seqdoop.hadoop_bam.SAMFormat;
import org.seqdoop.hadoop_bam.cli.CLIPlugin;
import org.seqdoop.hadoop_bam.cli.Utils;
import org.seqdoop.hadoop_bam.custom.jargs.gnu.CmdLineParser;
import org.seqdoop.hadoop_bam.util.Pair;
import org.seqdoop.hadoop_bam.util.SAMOutputPreparer;

public final class Cat
extends CLIPlugin {
    private static final List<Pair<CmdLineParser.Option, String>> optionDescs = new ArrayList<Pair<CmdLineParser.Option, String>>();
    private static final CmdLineParser.Option verboseOpt = new CmdLineParser.Option.BooleanOption('v', "verbose");
    private static final CmdLineParser.Option stringencyOpt = new CmdLineParser.Option.StringOption("validation-stringency=S");

    public Cat() {
        super("cat", "concatenation of partial SAM and BAM files", "1.1", "OUTPATH INPATH [INPATH...]", optionDescs, "Reads the SAM or BAM files in the given INPATHs and outputs the reads contained within them directly to OUTPATH. Performs no format conversions: simply concatenates the files. Note that BAM files should not have terminator blocks in them, as they will also be copied, which could confuse some tools.\n\nEach INPATH can be a glob pattern as understood by Hadoop.\n\nThe header used in OUTPATH is selected from the first INPATH. The output format is always the same as that of the INPATHs, and thus is selected based on the first INPATH or its contents.");
    }

    @Override
    protected int run(CmdLineParser parser) {
        FSDataOutputStream out;
        SAMFileHeader header;
        List<String> args = parser.getRemainingArgs();
        if (args.isEmpty()) {
            System.err.println("cat :: OUTPATH not given.");
            return 3;
        }
        if (args.size() == 1) {
            System.err.println("cat :: no INPATHs given.");
            return 3;
        }
        Path outPath = new Path(args.get(0));
        List<String> ins = args.subList(1, args.size());
        boolean verbose = parser.getBoolean(verboseOpt);
        ValidationStringency stringency = Utils.toStringency(parser.getOptionValue(stringencyOpt, ValidationStringency.DEFAULT_STRINGENCY.toString()), "cat");
        if (stringency == null) {
            return 3;
        }
        Configuration conf = this.getConf();
        ArrayList<Path> inputs = new ArrayList<Path>(ins.size());
        for (String in : ins) {
            try {
                Path p = new Path(in);
                for (FileStatus fstat : p.getFileSystem(conf).globStatus(p)) {
                    inputs.add(fstat.getPath());
                }
            }
            catch (IOException e) {
                System.err.printf("cat :: Could not expand glob pattern '%s': %s\n", in, e.getMessage());
            }
        }
        Path input0 = (Path)inputs.get(0);
        SAMFormat format = SAMFormat.inferFromFilePath(input0);
        if (format == null) {
            try {
                format = SAMFormat.inferFromData((InputStream)input0.getFileSystem(conf).open(input0));
            }
            catch (IOException e) {
                System.err.printf("cat :: Could not read input '%s': %s\n", input0, e.getMessage());
                return 4;
            }
            if (format == null) {
                System.err.printf("cat :: Unknown SAM format in input '%s'\n", inputs.get(0));
                return 4;
            }
        }
        try {
            SamReader r = SamReaderFactory.makeDefault().validationStringency(stringency).open(SamInputResource.of((InputStream)input0.getFileSystem(conf).open(input0)));
            header = r.getFileHeader();
            r.close();
        }
        catch (IOException e) {
            System.err.printf("cat :: Could not read input '%s': %s\n", input0, e.getMessage());
            return 5;
        }
        try {
            out = outPath.getFileSystem(conf).create(outPath);
        }
        catch (IOException e) {
            System.err.printf("cat :: Could not create output file: %s\n", e.getMessage());
            return 6;
        }
        try {
            new SAMOutputPreparer().prepareForRecords((OutputStream)out, format, header);
        }
        catch (IOException e) {
            System.err.printf("cat :: Outputting header failed: %s\n", e.getMessage());
            return 7;
        }
        int inIdx = 1;
        try {
            for (Path inPath : inputs) {
                if (verbose) {
                    System.out.printf("cat :: Concatenating path %d of %d...\n", inIdx++, inputs.size());
                }
                switch (format) {
                    case SAM: {
                        FSDataInputStream in = inPath.getFileSystem(conf).open(inPath);
                        SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)in)).getFileHeader();
                        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)false);
                        in.close();
                        break;
                    }
                    case BAM: {
                        int slen;
                        int i;
                        int prev;
                        FSDataInputStream in = inPath.getFileSystem(conf).open(inPath);
                        ByteBuffer block = ByteBuffer.wrap(new byte[65535]).order(ByteOrder.LITTLE_ENDIAN);
                        int read = 0;
                        while ((prev = in.read(block.array(), read, block.capacity() - read)) < block.capacity() && prev != -1) {
                            read += prev;
                        }
                        int blockLength = 0;
                        int xlen = block.getShort(10) & 0xFFFF;
                        int end = i + xlen;
                        for (i = 12; i < end; i += 4 + slen) {
                            slen = block.getShort(i + 2) & 0xFFFF;
                            if (block.getShort(i) != 17218 || slen != 2) continue;
                            blockLength = (block.getShort(i + 4) & 0xFFFF) + 1;
                            break;
                        }
                        if (blockLength == 0) {
                            throw new IOException("BGZF extra field not found in " + inPath);
                        }
                        if (verbose) {
                            System.err.printf("cat ::   first block length %d\n", blockLength);
                        }
                        ByteArrayInputStream blockIn = new ByteArrayInputStream(block.array(), 0, blockLength);
                        BlockCompressedInputStream bin = new BlockCompressedInputStream((InputStream)blockIn);
                        ByteBuffer buf = ByteBuffer.wrap(new byte[8]).order(ByteOrder.LITTLE_ENDIAN);
                        IOUtils.readFully((InputStream)bin, (byte[])buf.array(), (int)0, (int)8);
                        int magic = buf.getInt(0);
                        int headerLen = buf.getInt(4);
                        if (magic != 21840194) {
                            throw new IOException("bad BAM magic number in " + inPath);
                        }
                        IOUtils.skipFully((InputStream)bin, (long)headerLen);
                        IOUtils.readFully((InputStream)bin, (byte[])buf.array(), (int)0, (int)4);
                        int i2 = buf.getInt(0);
                        while (i2-- > 0) {
                            IOUtils.readFully((InputStream)bin, (byte[])buf.array(), (int)0, (int)4);
                            IOUtils.skipFully((InputStream)bin, (long)(buf.getInt(0) + 4));
                        }
                        int remaining = bin.available();
                        if (verbose) {
                            System.err.printf("cat ::   %d bytes to bgzip\n", remaining);
                        }
                        if (remaining > 0) {
                            byte[] remBuf = new byte[remaining];
                            IOUtils.readFully((InputStream)bin, (byte[])remBuf, (int)0, (int)remBuf.length);
                            BlockCompressedOutputStream bout = new BlockCompressedOutputStream((OutputStream)out, null);
                            bout.write(remBuf);
                            bout.flush();
                        }
                        in.seek((long)blockLength);
                        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)false);
                        in.close();
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.printf("cat :: Outputting records failed: %s\n", e.getMessage());
            return 8;
        }
        try {
            if (format == SAMFormat.BAM) {
                out.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
            }
            out.close();
        }
        catch (IOException e) {
            System.err.printf("cat :: Finishing output failed: %s\n", e.getMessage());
            return 9;
        }
        return 0;
    }

    static {
        optionDescs.add(new Pair<CmdLineParser.Option, String>(verboseOpt, "report progress verbosely"));
        optionDescs.add(new Pair<CmdLineParser.Option, String>(stringencyOpt, Utils.getStringencyOptHelp()));
    }
}

