/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins;

import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.seqdoop.hadoop_bam.cli.CLIPlugin;
import org.seqdoop.hadoop_bam.cli.Utils;
import org.seqdoop.hadoop_bam.custom.jargs.gnu.CmdLineParser;
import org.seqdoop.hadoop_bam.util.Pair;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public final class Index
extends CLIPlugin {
    private static final List<Pair<CmdLineParser.Option, String>> optionDescs = new ArrayList<Pair<CmdLineParser.Option, String>>();
    private static final CmdLineParser.Option stringencyOpt = new CmdLineParser.Option.StringOption("validation-stringency=S");

    public Index() {
        super("index", "BAM indexing", "1.1", "PATH [OUT]", optionDescs, "Indexes the BAM file in PATH to OUT, or PATH.bai by default.");
    }

    @Override
    protected int run(CmdLineParser parser) {
        BAMIndexer indexer;
        SAMFileHeader header;
        SamReader reader;
        List<String> args = parser.getRemainingArgs();
        if (args.isEmpty()) {
            System.err.println("index :: PATH not given.");
            return 3;
        }
        if (args.size() > 2) {
            System.err.printf("index :: Too many arguments: expected at most 2, got %d.\n", args.size());
            return 3;
        }
        ValidationStringency stringency = Utils.toStringency(parser.getOptionValue(stringencyOpt, ValidationStringency.DEFAULT_STRINGENCY.toString()), "index");
        if (stringency == null) {
            return 3;
        }
        String path = args.get(0);
        String out = args.size() > 1 ? args.get(1) : path + ".bai";
        try {
            reader = SamReaderFactory.makeDefault().setOption(SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS, true).setOption(SamReaderFactory.Option.EAGERLY_DECODE, false).validationStringency(stringency).open(SamInputResource.of(WrapSeekable.openPath(this.getConf(), new Path(path))));
        }
        catch (Exception e) {
            System.err.printf("index :: Could not open '%s': %s\n", path, e.getMessage());
            return 4;
        }
        try {
            header = reader.getFileHeader();
        }
        catch (SAMFormatException e) {
            System.err.printf("index :: Could not parse '%s': %s\n", path, e.getMessage());
            return 6;
        }
        try {
            Path p = new Path(out);
            indexer = new BAMIndexer((OutputStream)p.getFileSystem(this.getConf()).create(p), header);
        }
        catch (Exception e) {
            System.err.printf("index :: Could not open '%s' for output: %s\n", out, e.getMessage());
            return 5;
        }
        SAMRecordIterator it = reader.iterator();
        try {
            while (it.hasNext()) {
                indexer.processAlignment((SAMRecord)it.next());
            }
        }
        catch (SAMFormatException e) {
            System.err.printf("index :: Could not parse '%s': %s\n", path, e.getMessage());
            return 6;
        }
        indexer.finish();
        return 0;
    }

    static {
        optionDescs.add(new Pair<CmdLineParser.Option, String>(stringencyOpt, Utils.getStringencyOptHelp()));
    }
}

