/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins;

import hbparquet.hadoop.util.ContextUtil;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.BAMRecordReader;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.cli.Utils;

final class SortRecordReader
extends RecordReader<LongWritable, SAMRecordWritable> {
    private final RecordReader<LongWritable, SAMRecordWritable> baseRR;
    private Configuration conf;

    public SortRecordReader(RecordReader<LongWritable, SAMRecordWritable> rr) {
        this.baseRR = rr;
    }

    public void initialize(InputSplit spl, TaskAttemptContext ctx) throws InterruptedException, IOException {
        this.conf = ContextUtil.getConfiguration((JobContext)ctx);
    }

    public void close() throws IOException {
        this.baseRR.close();
    }

    public float getProgress() throws InterruptedException, IOException {
        return this.baseRR.getProgress();
    }

    public LongWritable getCurrentKey() throws InterruptedException, IOException {
        return (LongWritable)this.baseRR.getCurrentKey();
    }

    public SAMRecordWritable getCurrentValue() throws InterruptedException, IOException {
        return (SAMRecordWritable)this.baseRR.getCurrentValue();
    }

    public boolean nextKeyValue() throws InterruptedException, IOException {
        if (!this.baseRR.nextKeyValue()) {
            return false;
        }
        SAMRecord rec = this.getCurrentValue().get();
        int ri = rec.getReferenceIndex();
        Utils.correctSAMRecordForMerging(rec, this.conf);
        if (rec.getReferenceIndex() != ri) {
            this.getCurrentKey().set(BAMRecordReader.getKey(rec));
        }
        return true;
    }
}

