/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins;

import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.InputSampler;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.seqdoop.hadoop_bam.VCFFormat;
import org.seqdoop.hadoop_bam.VCFInputFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.seqdoop.hadoop_bam.cli.CLIMRPlugin;
import org.seqdoop.hadoop_bam.cli.Utils;
import org.seqdoop.hadoop_bam.cli.plugins.SortOutputFormat;
import org.seqdoop.hadoop_bam.cli.plugins.VCFSortReducer;
import org.seqdoop.hadoop_bam.custom.jargs.gnu.CmdLineParser;
import org.seqdoop.hadoop_bam.util.Pair;
import org.seqdoop.hadoop_bam.util.Timer;
import org.seqdoop.hadoop_bam.util.VCFHeaderReader;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public final class VCFSort
extends CLIMRPlugin {
    private static final List<Pair<CmdLineParser.Option, String>> optionDescs = new ArrayList<Pair<CmdLineParser.Option, String>>();
    private static final CmdLineParser.Option formatOpt = new CmdLineParser.Option.StringOption('F', "format=FMT");
    private static final CmdLineParser.Option noTrustExtsOpt = new CmdLineParser.Option.BooleanOption("no-trust-exts");

    public VCFSort() {
        super("vcf-sort", "VCF and BCF sorting", "1.0", "WORKDIR INPATH", optionDescs, "Sorts the VCF or BCF file given as INPATH in a distributed fashion using Hadoop MapReduce. Output parts are placed in WORKDIR in, by default, headerless and unterminated BCF format.");
    }

    @Override
    protected int run(CmdLineParser parser) {
        List<String> args = parser.getRemainingArgs();
        if (args.isEmpty()) {
            System.err.println("vcf-sort :: WORKDIR not given.");
            return 3;
        }
        if (args.size() == 1) {
            System.err.println("vcf-sort :: INPATH not given.");
            return 3;
        }
        if (!this.cacheAndSetProperties(parser)) {
            return 3;
        }
        Path wrkDir = new Path(args.get(0));
        Path inPath = new Path(args.get(1));
        Configuration conf = this.getConf();
        VCFFormat vcfFormat = null;
        String f = (String)parser.getOptionValue(formatOpt);
        if (f != null) {
            try {
                vcfFormat = VCFFormat.valueOf(f.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                System.err.printf("%s :: invalid format '%s'\n", this.getCommandName(), f);
                return 3;
            }
        }
        if (vcfFormat == null) {
            vcfFormat = this.outPath == null ? VCFFormat.BCF : VCFFormat.inferFromFilePath(this.outPath);
        }
        conf.setBoolean("hadoopbam.vcf.trust-exts", !parser.getBoolean(noTrustExtsOpt));
        conf.setBoolean("hadoopbam.vcf.write-header", this.outPath == null);
        conf.set("hadoopbam.vcf.output-format", vcfFormat.toString());
        String intermediateOutName = (this.outPath == null ? inPath : this.outPath).getName();
        conf.set("hadoopbam.work.filename", intermediateOutName);
        conf.set("hadoopbam.vcfsort.inpath", inPath.toString());
        Timer t = new Timer();
        try {
            wrkDir = wrkDir.getFileSystem(conf).makeQualified(wrkDir);
            Utils.configureSampling(wrkDir, intermediateOutName, conf);
            Job job = new Job(conf);
            job.setJarByClass(VCFSort.class);
            job.setMapperClass(Mapper.class);
            job.setReducerClass(VCFSortReducer.class);
            job.setMapOutputKeyClass(LongWritable.class);
            job.setOutputKeyClass(NullWritable.class);
            job.setOutputValueClass(VariantContextWritable.class);
            job.setInputFormatClass(VCFInputFormat.class);
            job.setOutputFormatClass(SortOutputFormat.class);
            FileInputFormat.addInputPath((Job)job, (Path)inPath);
            FileOutputFormat.setOutputPath((Job)job, (Path)wrkDir);
            job.setPartitionerClass(TotalOrderPartitioner.class);
            System.out.println("vcf-sort :: Sampling...");
            t.start();
            InputSampler.writePartitionFile((Job)job, (InputSampler.Sampler)new InputSampler.RandomSampler(0.01, 10000, Math.max(100, this.reduceTasks)));
            System.out.printf("vcf-sort :: Sampling complete in %d.%03d s.\n", t.stopS(), t.fms());
            job.submit();
            System.out.println("vcf-sort :: Waiting for job completion...");
            t.start();
            if (!job.waitForCompletion(this.verbose)) {
                System.err.println("vcf-sort :: Job failed.");
                return 4;
            }
            System.out.printf("vcf-sort :: Job complete in %d.%03d s.\n", t.stopS(), t.fms());
        }
        catch (IOException e) {
            System.err.printf("vcf-sort :: Hadoop error: %s\n", e);
            return 4;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.outPath != null) {
            try {
                VariantContextWriter writer;
                System.out.println("vcf-sort :: Merging output...");
                t.start();
                FSDataOutputStream outs = this.outPath.getFileSystem(conf).create(this.outPath);
                WrapSeekable<FSDataInputStream> ins = WrapSeekable.openPath(conf, inPath);
                VCFHeader header = VCFHeaderReader.readHeaderFrom(ins);
                ins.close();
                switch (vcfFormat) {
                    case VCF: {
                        writer = new VariantContextWriterBuilder().clearOptions().setOutputStream((OutputStream)new FilterOutputStream((OutputStream)outs){

                            @Override
                            public void close() throws IOException {
                                this.out.flush();
                            }
                        }).build();
                        break;
                    }
                    case BCF: {
                        writer = new VariantContextWriterBuilder().clearOptions().setOutputBCFStream((OutputStream)new FilterOutputStream((OutputStream)new BlockCompressedOutputStream((OutputStream)outs, null)){

                            @Override
                            public void close() throws IOException {
                                this.out.flush();
                            }
                        }).build();
                        break;
                    }
                    default: {
                        assert (false);
                        writer = null;
                    }
                }
                writer.writeHeader(header);
                writer.close();
                Utils.mergeInto((OutputStream)outs, wrkDir, "", "", conf, "vcf-sort");
                if (vcfFormat == VCFFormat.BCF) {
                    outs.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
                }
                outs.close();
                System.out.printf("vcf-sort :: Merging complete in %d.%03d s.\n", t.stopS(), t.fms());
            }
            catch (IOException e) {
                System.err.printf("vcf-sort :: Output merging failed: %s\n", e);
                return 5;
            }
        }
        return 0;
    }

    static {
        optionDescs.add(new Pair<CmdLineParser.Option, String>(noTrustExtsOpt, "detect SAM/BAM files only by contents, never by file extension"));
        optionDescs.add(new Pair<CmdLineParser.Option, String>(formatOpt, "select the output format based on FMT: VCF or BCF"));
        optionDescs.add(new Pair<CmdLineParser.Option, String>(outputPathOpt, "output a complete VCF/BCF file to the file PATH, removing the parts from WORKDIR; VCF/BCF is chosen by file extension, if appropriate (but -F takes precedence)"));
    }
}

