/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import org.apache.hadoop.conf.Configuration;

public class ConfHelper {
    public static boolean parseBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        value = value.trim();
        String[] acceptedTrue = new String[]{"yes", "true", "t", "y", "1"};
        String[] acceptedFalse = new String[]{"no", "false", "f", "n", "0"};
        for (String possible : acceptedTrue) {
            if (!possible.equalsIgnoreCase(value)) continue;
            return true;
        }
        for (String possible : acceptedFalse) {
            if (!possible.equalsIgnoreCase(value)) continue;
            return false;
        }
        throw new IllegalArgumentException("Unrecognized boolean value '" + value + "'");
    }

    public static boolean parseBoolean(Configuration conf, String propertyName, boolean defaultValue) {
        return ConfHelper.parseBoolean(conf.get(propertyName), defaultValue);
    }
}

