/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

public final class MurmurHash3 {
    public static long murmurhash3(byte[] key, int seed) {
        long k2;
        long k1;
        ByteBuffer data = ByteBuffer.wrap(key).order(ByteOrder.LITTLE_ENDIAN);
        int len = key.length;
        int nblocks = len / 16;
        long h1 = seed;
        long h2 = seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        LongBuffer blocks = data.asLongBuffer();
        for (int i = 0; i < nblocks; ++i) {
            k1 = blocks.get(i * 2 + 0);
            k2 = blocks.get(i * 2 + 1);
            k1 *= -8663945395140668459L;
            k1 = k1 << 31 | k1 >>> 33;
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = h1 << 27 | h1 >>> 37;
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = k2 << 33 | k2 >>> 31;
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = h2 << 31 | h1 >>> 33;
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        data.position(nblocks * 16);
        ByteBuffer tail = data.slice();
        k1 = 0L;
        k2 = 0L;
        switch (len & 0xF) {
            case 15: {
                k2 ^= ((long)tail.get(14) & 0xFFL) << 48;
            }
            case 14: {
                k2 ^= ((long)tail.get(13) & 0xFFL) << 40;
            }
            case 13: {
                k2 ^= ((long)tail.get(12) & 0xFFL) << 32;
            }
            case 12: {
                k2 ^= ((long)tail.get(11) & 0xFFL) << 24;
            }
            case 11: {
                k2 ^= ((long)tail.get(10) & 0xFFL) << 16;
            }
            case 10: {
                k2 ^= ((long)tail.get(9) & 0xFFL) << 8;
            }
            case 9: {
                k2 ^= ((long)tail.get(8) & 0xFFL) << 0;
                k2 *= 5545529020109919103L;
                k2 = k2 << 33 | k2 >>> 31;
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 8: {
                k1 ^= ((long)tail.get(7) & 0xFFL) << 56;
            }
            case 7: {
                k1 ^= ((long)tail.get(6) & 0xFFL) << 48;
            }
            case 6: {
                k1 ^= ((long)tail.get(5) & 0xFFL) << 40;
            }
            case 5: {
                k1 ^= ((long)tail.get(4) & 0xFFL) << 32;
            }
            case 4: {
                k1 ^= ((long)tail.get(3) & 0xFFL) << 24;
            }
            case 3: {
                k1 ^= ((long)tail.get(2) & 0xFFL) << 16;
            }
            case 2: {
                k1 ^= ((long)tail.get(1) & 0xFFL) << 8;
            }
            case 1: {
                k1 ^= ((long)tail.get(0) & 0xFFL) << 0;
                k1 *= -8663945395140668459L;
                k1 = k1 << 31 | k1 >>> 33;
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= (long)len;
        h1 += (h2 ^= (long)len);
        h2 += h1;
        h1 = MurmurHash3.fmix(h1);
        h2 = MurmurHash3.fmix(h2);
        return h1 += h2;
    }

    public static long murmurhash3(CharSequence chars, int seed) {
        int len = chars.length();
        int nblocks = len / 8;
        long h1 = seed;
        long h2 = seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        for (int i = 0; i < nblocks; ++i) {
            int i0 = (i * 2 + 0) * 4;
            int i1 = (i * 2 + 1) * 4;
            long k1 = (long)chars.charAt(i0) | (long)chars.charAt(i0 + 1) << 16 | (long)chars.charAt(i0 + 2) << 32 | (long)chars.charAt(i0 + 3) << 48;
            long k2 = (long)chars.charAt(i1) | (long)chars.charAt(i1 + 1) << 16 | (long)chars.charAt(i1 + 2) << 32 | (long)chars.charAt(i1 + 3) << 48;
            k1 *= -8663945395140668459L;
            k1 = k1 << 31 | k1 >>> 33;
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = h1 << 27 | h1 >>> 37;
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = k2 << 33 | k2 >>> 31;
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = h2 << 31 | h1 >>> 33;
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        long k1 = 0L;
        long k2 = 0L;
        switch (len & 7) {
            case 7: {
                k2 ^= (long)chars.charAt(6) << 32;
            }
            case 6: {
                k2 ^= (long)chars.charAt(5) << 16;
            }
            case 5: {
                k2 ^= (long)chars.charAt(4) << 0;
                k2 *= 5545529020109919103L;
                k2 = k2 << 33 | k2 >>> 31;
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 4: {
                k1 ^= (long)chars.charAt(3) << 48;
            }
            case 3: {
                k1 ^= (long)chars.charAt(2) << 32;
            }
            case 2: {
                k1 ^= (long)chars.charAt(1) << 16;
            }
            case 1: {
                k1 ^= (long)chars.charAt(0) << 0;
                k1 *= -8663945395140668459L;
                k1 = k1 << 31 | k1 >>> 33;
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= (long)len;
        h1 += (h2 ^= (long)len);
        h2 += h1;
        h1 = MurmurHash3.fmix(h1);
        h2 = MurmurHash3.fmix(h2);
        return h1 += h2;
    }

    private static long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }
}

