/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.seqdoop.hadoop_bam.SAMFormat;

public class SAMOutputPreparer {
    private ByteBuffer buf = ByteBuffer.wrap(new byte[4]);
    public static final byte[] BAM_MAGIC = new byte[]{66, 65, 77, 1};

    public SAMOutputPreparer() {
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public OutputStream prepareForRecords(OutputStream out, SAMFormat format, SAMFileHeader header) throws IOException {
        switch (format) {
            case SAM: {
                out = this.prepareSAMOrBAMStream(out, format, header);
                break;
            }
            case BAM: {
                out = this.prepareSAMOrBAMStream(out, format, header);
                break;
            }
            case CRAM: {
                out = this.prepareCRAMStream(out, format, header);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported SAM file format, must be one of SAM, BAM or CRAM");
            }
        }
        out.flush();
        return out;
    }

    private OutputStream prepareCRAMStream(OutputStream out, SAMFormat format, SAMFileHeader header) throws IOException {
        CramIO.writeHeader((Version)CramVersions.DEFAULT_CRAM_VERSION, (OutputStream)out, (SAMFileHeader)header, null);
        return out;
    }

    private OutputStream prepareSAMOrBAMStream(OutputStream out, SAMFormat format, SAMFileHeader header) throws IOException {
        StringWriter sw = new StringWriter();
        new SAMTextHeaderCodec().encode((Writer)sw, header);
        String text = sw.toString();
        if (format == SAMFormat.BAM) {
            out = new BlockCompressedOutputStream(out, null);
            out.write(BAM_MAGIC);
            this.writeInt32(out, text.length());
        }
        SAMOutputPreparer.writeString(out, text);
        if (format == SAMFormat.BAM) {
            List refs = header.getSequenceDictionary().getSequences();
            this.writeInt32(out, refs.size());
            for (SAMSequenceRecord ref : refs) {
                String name = ref.getSequenceName();
                this.writeInt32(out, name.length() + 1);
                SAMOutputPreparer.writeString(out, name);
                out.write(0);
                this.writeInt32(out, ref.getSequenceLength());
            }
        }
        return out;
    }

    private static void writeString(OutputStream out, String s) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(new FilterOutputStream(out){

            @Override
            public void flush() {
            }
        });
        w.write(s);
        w.flush();
    }

    private void writeInt32(OutputStream out, int n) throws IOException {
        this.buf.putInt(0, n);
        out.write(this.buf.array());
    }
}

